/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------
File:                           JawaaNode.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
                                
-------------------------------------------------------------------------------*/
package jawaa.structure;

import jawaa.anim.AnimController;
import jawaa.object.*;
import jawaa.app.*;
import java.awt.*;
import jawaa.util.*;


public class JawaaNode extends JawaaContainer implements Scalable
{
    public JawaaNode (String name,
		      Color foreground, Color background, Color textColor,
		      String[] s,
		      int x, int y, int width, int height)
    {
	FontMetrics metric = AnimController.getFontMetrics();
	myColor = foreground;
	myName = name;
	myBackground = background;
	myTextColor =  textColor;
	myLocation = new Point(x, y);
	myWidth = width;
	myHeight = height;
	myOutline = new JawaaRectangle(myLocation.x, myLocation.y,
				       myWidth, myHeight,
				       myColor, myBackground);
	makeText(metric, s, myLocation);
	setTextLocations();
    }

    public JawaaNode (String name,
		      Color foreground, Color background, Color textColor,
		      JawaaText[] s,
		      Point loc, int width, int height, JawaaShape outline)
    {
	myName = name;
	myColor = foreground;
	myBackground = background;
	myTextColor = textColor;
	myText = s;
	myLocation = loc;
	myWidth = width;
	myHeight = height;
	myOutline = outline;
    }
    
    public JawaaNode (String[] args)
    {
	FontMetrics metric = AnimController.getFontMetrics();
	try
	{
	    myLocation = new Point(Integer.parseInt(args[2]),
				   Integer.parseInt(args[3]));
	    myWidth = Integer.parseInt(args[4]);
	    myHeight = Integer.parseInt(args[5]);
	    myItemCount = Integer.parseInt(args[6]);
	    String[] temp = new String[myItemCount];
	    int i = 7;
	    int longest = 0;
	    for(int j = 0; j < myItemCount; j++)
	    {
		if (metric.stringWidth(args[i]) > longest)
		    longest = metric.stringWidth(args[i]);
		temp[j] = args[i];
		i++;
	    }
	    myColor = ColorFactory.getColor(args[i++]);
	    myBackground = ColorFactory.getColor(args[i++]);
	    myTextColor = ColorFactory.getColor(args[i++]);

	    if (args[i].equals("CIRCLE"))	makeCircle(metric, longest, temp);
	    else if (args[i].equals("RECT"))	makeRect(metric, longest, temp);
	    else 		                makeRect(metric, longest,temp);
	    setTextLocations();
	}
	catch (Exception e)
	{
	    ErrorHandler.error(this, "syntax error", true);
	}
    }

    protected void makeCircle (FontMetrics metric, int longest, String[] s)
    {
	myOutline = new JawaaCircle(myLocation.x, myLocation.y,
				    myWidth, myColor, myBackground);
	makeText(metric, s, calcVertOffset(metric, s, myLocation));
    }

    protected void makeRect (FontMetrics metric, int longest, String[] s)
    {
	myOutline = new JawaaRectangle(myLocation.x, myLocation.y,
				       myWidth, myHeight,
				       myColor, myBackground);
	makeText(metric, s, calcVertOffset(metric, s, myLocation));
    }

    protected void makeText(FontMetrics metric, String[] s, Point start)
    {
	myText = new JawaaText[s.length];
	for (int i = 0; i < s.length; i++)
	{
	    Point offset = new Point(0,0);
	    myText[i] = new JawaaText(s[i], offset, myTextColor);
	}
    }

    protected Point calcVertOffset (FontMetrics metric, String[] s, Point point)
    {
	int offset = getCenter().y - point.y;
	if (s.length % 2 != 0)
	{
	    offset -= metric.getMaxAscent();
	}

	int index = s.length / 2;
	for (int i = 0; i < index; i++)
	{
	    offset -= (metric.getMaxAscent() + metric.getMaxDescent() + 2);
	}

	if (offset < 0)    return point;
	else               return new Point(point.x, point.y + offset);
    }

    private void setTextLocations ()
    {
	FontMetrics metric = AnimController.getFontMetrics();
	BoundingBox b = getBoundingBox(myText);
	Point p = b.setCenter(getCenter());
	
	int height = 0;
	for(int i = 0; i<myText.length; i++)
	{
	    if(i!=0)
	    {
		height += myText[i].getMaxAscent() + 2 + myText[i-1].getMaxDescent();
	    }
	    else
	    {
		height += myText[i].getMaxAscent() + 2;
	    }
	    myText[i].setLocation(p.x+calcHorzOffset(myText[i], b.width),p.y+height);
	}
    }
    
    public BoundingBox getBoundingBox (JawaaText[] s)
    {
	int width = 0, height = 0;

	for(int i = 0; i < s.length; i++)
	{
	    height += s[i].getHeight() + 2;
	    if (s[i].stringWidth() > width)
	    {
		width = s[i].stringWidth();
	    }
	}

	return new BoundingBox(width, height);
    }

    
    protected int calcHorzOffset (FontMetrics metric, String s, int width)
    {
	int offset = 0;
	offset = (width - metric.stringWidth(s))/2;
	if(offset < 0)
	    return 0;
	else return offset;
    }

    protected int calcHorzOffset (JawaaText t, int width)
    {
	int offset = 0;
	offset = (width - t.stringWidth())/2;
	if(offset < 0)
	    return 0;
	else return offset;
    }


    public void offsetLocation (int x, int y)
    {
	myLocation.x += x;
	myLocation.y += y;

	myOutline.offsetLocation(x, y);
	for(int i = 0; i < myText.length; i++)
	{
	    myText[i].offsetLocation(x, y);
	}
    }

    public void setLocation (int x, int y)
    {
	myLocation.x = x;
	myLocation.y = y;

	Point p = myOutline.getLocation();
	for(int i= 0; i< myText.length; i++)
	{
	    myText[i].offsetLocation(x-p.x, y-p.y);
	}
	myOutline.setLocation(x,y);
    }

    public void setTextColor(String s)
    {
	myTextColor = ColorFactory.getColor(s);
	for (int i=0;i<myText.length;i++)
	    myText[i].setTextColor(s);
    }

    public void setTextColor(Color color)
    {
	myTextColor = color;
	for (int i=0;i<myText.length;i++)
	    myText[i].setTextColor(color);
    }

    public Color getTextColor()
    {
	return myTextColor;
    }
    
   


    public void paint (Graphics g)
    {
	if (changed())
	    setTextLocations();
	myOutline.paint(g);
	for (int i = 0; i<myText.length; i++)
	    myText[i].paint(g);
    }

    public boolean changed ()
    {
	boolean result = false;
	for (int i = 0; i<myText.length; i++)
	{
	    if (myText[i].changed)
	    {
		myText[i].changed = false;
		result = true;
	    }
	}

	return result;
    }

    public JawaaText[] getAllText()
    {
	return myText;
    }
    
    public JawaaObject get(int i)
    {
	if(i < myText.length)
	    return myText[i];
	return null;
    }

    public void setText(String s)
    {
	int i = 0;
	if(i <myText.length)
	    myText[i].setText(s);
    }

    public void setTexts(String s, int i)
    {
	myText[i].setText(s);
    }

    public void setTextSize(int size)
    {
	int i = 0;
	if ( i <myText.length)
	    myText[i].setSize(size);
    }

    public void setColor(String s)
    {
	myOutline.setColor(s);
    }

    public void setColor(Color c)
    {
	myOutline.setColor(c);
    }

    public void setBackground(String s)
    {
	myOutline.setBackground(s);
    }

    public void setBackground(Color s)
    {
	myOutline.setBackground(s);
    }

    public int getItemCount()
    {
	return myText.length;
    }
    
    public void init()
    {
	myIndex = 0;
    }

    public boolean hasNext()
    {
	return myIndex < myText.length;
    }

    public Object next()
    {
	return myText[myIndex++];
    }

    public String toString()
    {
	return myName;
    }

    public Object nextText()
    {
	return myText[0];
    }
    /**
     * Scalable Interface methods..
     */
    
    public int[] getSize()
    {
	int[] temp = {((Scalable)myOutline).getSize()[0],
		      ((Scalable)myOutline).getSize()[1]};
	return temp;
	
    }

    public void setSize(int[] temp)
    {
	((Scalable)myOutline).setSize(temp);
	myWidth = temp[0];
	myHeight = temp[1];
	setTextLocations();
    }
    /**
     * End Scalable methods.
     */

    public JawaaShape getOutline()
    {
	return myOutline;
    }
    
    protected  int myItemCount = 0;    //data items per node
    protected JawaaText[] myText;
    protected JawaaShape myOutline;
    private int myIndex = 0;

    class BoundingBox
    {
	public int width, height;
	
	public BoundingBox(int i, int j)
	{
	    width = i;
	    height = j;
	}

	public Point setCenter(Point p)
	{
	    return new Point(p.x-width/2, p.y-height/2);
	}
    }

}
