/*-------------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

--------------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------------*/
package jawaa.object;

import java.awt.*;
import jawaa.structure.MultiPointContainer;
import jawaa.util.ErrorHandler;


public class JawaaLine extends JawaaObject implements MultiPointContainer
{
    public JawaaLine (String[] args)
    {
	super(args);
    }

    public void build (String[] args) throws
        ArrayIndexOutOfBoundsException, NumberFormatException, Exception
    {
	myLocation = new Point(Integer.parseInt(args[2]),
			       Integer.parseInt(args[3]));
	myEndLocation = new Point(Integer.parseInt(args[4]),
				  Integer.parseInt(args[5]));
	setColor(args[6]);
    }
    
    public void paint (Graphics g)
    {
	if (myColor.getRGB() != -5544)
        {
	    g.setColor(myColor);
	    g.drawLine(myLocation.x, myLocation.y, myEndLocation.x, myEndLocation.y);
	}
    }

    public void offsetLocation (int x, int y)
    {
	myLocation.x += x;
	myLocation.y += y;
	myEndLocation.x += x;
	myEndLocation.y += y;
    }

    public void setLocation (int x, int y)
    {
	offsetLocation(x - myLocation.x, y - myLocation.y);
    }

    public Point getLocation (int k)
    {
	if (k==0)	  return myLocation;
	else if (k==1)    return myEndLocation;
	else
	{
	    ErrorHandler.error(this, "syntax error: only two points exist");
	}
	return null;
    }

    public void setLocation (int x, int y, int k)
    {
       if (k == 0)
       {
	   myLocation.x = x;
	   myLocation.y = y;
       }
       else if (k == 1)
       {
	   myEndLocation.x = x;
	   myEndLocation.y = y;
       }
       else
       {
	   ErrorHandler.error(this, "syntax error: only two points exist");
       }
    }


    private Point myEndLocation;
    private final String NUMBER_EXCEPTION = "invalid location";
}
