/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 20012
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------*/
package jawaa.extras.marker;

import jawaa.util.*;
import java.awt.*;
import jawaa.object.*;
import jawaa.extras.PositionListener;

public class JawaaMarker extends JawaaCircle implements PositionListener
{
    public JawaaMarker(String[] args)
    {
	try{
	    build(args);
	}
	catch(Exception e)
	{
	    System.out.println(toString() +":syntax error");
	}
    }

    public void build(String[] args) throws
    ArrayIndexOutOfBoundsException, NumberFormatException, Exception
    {
	myName = args[1];
	myNode = args[2];
	myWidth = Integer.parseInt(args[3]);
	myHeight = myWidth;
	myColor = ColorFactory.getColor(args[4]);
	myBackground = ColorFactory.getColor(args[5]);

	JawaaHash hash = JawaaHash.getInstance();
	try{
	    myTarget = (Markable)hash.get(myNode);
	    myIndex = myTarget.addMarkerListener(this);
	    Point p = myTarget.getMarkerHandle(myIndex);
	    setLocation(p.x-myWidth/2, p.y-myHeight/2);
	}
	catch(ClassCastException e)
	{
	    ErrorHandler.error(this, "markers can only be used on nodes", false);
	}
    }

    public void pointMoved()
    {
	myLocation = myTarget.getMarkerHandle(myIndex);
	myLocation.x = myLocation.x - myWidth/2;
	myLocation.y = myLocation.y - myHeight/2;
    }
    
    public void setNode(String n, Markable node)
    {
	myNode = n;
	myIndex = node.addMarkerListener(this);
	myTarget = node;
    }

    public void setNode(Markable node)
    {
	//name not set
	myTarget = node;
    }

    public Markable getMarkedNode()
    {
	return myTarget;
    }

    public int getIndex()
    {
	return myIndex;
    }
    
    protected int myIndex;
    protected Markable myTarget;
    String myNode;
}
