/*---------------------------------------------------------------------------
-- JAWAA 2.0 --
Copyright information:
Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------*/
package jawaa.command;

import java.awt.*;
import jawaa.util.*;
import jawaa.structure.*;
import jawaa.object.*;
import jawaa.extras.arrow.*;


public class LinkedListCommand extends JawaaCommand
{
    public LinkedListCommand (String[] args)
    {
	super("LinkedList");
	try
	{
	    myName = args[1];
	    myLocation = new Point();
	    myLocation.x = Integer.parseInt(args[2]);
	    myLocation.y = Integer.parseInt(args[3]);
	    myWidth = Integer.parseInt(args[4]);
	    myHeight = Integer.parseInt(args[5]);
	    myTitle = args[6];
	    int myNum = Integer.parseInt(args[7]);
	    int i = 8;
	    int k = 1;
	    int j = 1;

	    nodes = new String[myNum + 1];
	    nodeNames  = new String[myNum + 1];

	    for (; j < myNum + 1; j++)
	    {
		nodeNames[k] = args[i++];
		JawaaGraphNode obj = (JawaaGraphNode)myData.get(nodeNames[k]);
		if (obj == null)
		{
		    nodes[k] = args[i++];		    
		}
		else
		    nodes[k]="";
		k++;		
	    }

	    nodeNames[0] = myTitle;
	    nodes[0] = myTitle;
	    
	    if(args[i].equals("VERT"))
		myOrientation = 0;
	    else if(args[i].equals("HORZ"))
		myOrientation = 1;
	    else myOrientation = 0;

	    myColor = ColorFactory.getColor(args[++i]);
	    myBackground = ColorFactory.getColor(args[++i]);
	    myTextColor = ColorFactory.getColor(args[++i]);
	    i++;

	    if(args[i].equals("CIRCLE")) 
		{
		    myShape = "circle";
		}
	    else if (args[i].equals("RECT"))
		myShape = "rect";
	    else
		myShape = "rect";
	}
	catch(NumberFormatException e){
	    ErrorHandler.error(this, "syntax error ", e, true);
	}
	catch(ArrayIndexOutOfBoundsException e){
	    ErrorHandler.error(this, "syntax error ", e, true);
	}
    }

    public boolean step()
    {
	for(int i=0; i<myNodes.length; i++)
	    {

		if(myOrientation == 1)
		    myNodes[i].setLocation(myLocation.x+i*(myWidth+20),
					   myLocation.y);
		else
		    myNodes[i].setLocation(myLocation.x,
					   myLocation.y+i*(myHeight+20));
		

		if(i+1 < myNodes.length)
		    {
			
			SmartArrow arrow = myNodes[i].addChild(myNodes[i+1],
							       myColor);
			arrow.setName(myNodes[i].getName()+"_arrow");
		       	myData.put(myNodes[i].getName()+"_arrow", arrow);
			
			
		    } 
		
		
	    }
       
	myData.put(myName, new JawaaGroupObject(myName, nodeNames));
	return false;
    }

    
    public void setData()
    {
	myNodes = new JawaaGraphNode[nodes.length];
	try{	    
	    for(int i=0; i<nodes.length; i++)
	    { 
		Point loc = new Point(0,0);
		Point offset = new Point(myLocation.x, myLocation.y);
		
		JawaaGraphNode temp = (JawaaGraphNode)myData.get(nodeNames[i]);
				
		if(temp == null)
		{	
		    if (myShape == "circle")
			{
			    myOutline = new JawaaCircle(myLocation.x, 
							myLocation.y,
							myWidth, myColor, myBackground);
			}
		    else 
			{
			    myOutline = new JawaaRectangle(myLocation.x, 
							   myLocation.y,
							   myWidth, myHeight,
							   myColor, myBackground);
			}

		    transparent = new Color(-5544);

		    JawaaText [] tmp = new JawaaText[1];
		    tmp[0] = new JawaaText(nodes[i], offset, myTextColor);     
		    int wide = tmp[0].stringWidth();
		    int high = tmp[0].getHeight();
		    offset.x += ((myWidth - wide)/2);
		    offset.y += ((myHeight + high)/2);

		    if (i == 0 )
			{
			    if (myShape == "circle")
				{
				    myOutline = new JawaaCircle(myLocation.x, 
								myLocation.y,
								myWidth, transparent, transparent);
				}
			    else 
				{
				    myOutline = new JawaaRectangle(myLocation.x, 
								   myLocation.y,
								   myWidth, myHeight,
								   transparent,transparent);
				}
			    
			    temp = new JawaaGraphNode(nodeNames[i], transparent, transparent,
						      myTextColor, tmp, loc, myWidth,
						      myHeight, myOutline);
			}
		    else
			{
			     temp = new JawaaGraphNode(nodeNames[i], myColor, myBackground,
						      myTextColor, tmp, loc, myWidth,
						      myHeight, myOutline); 
			}   
		    
		    myData.put(nodeNames[i], temp);
			
		    
		}

		myNodes[i] = temp;
	    }
	}
	catch(Exception e){
	    ErrorHandler.error(this, "setData error ", e, true);
	}
	
    }

	
    private String myName;
    private String myTitle;
    private Point myLocation;
    private int myWidth;
    private int myHeight;
    private int myLength, myItemCount;
    private Color myColor;
    private Color myBackground;
    private Color myTextColor;
    private Color transparent;
    private String myShape;
    private int myOrientation;
    private JawaaShape myOutline;
    
    private String[] nodes;
    private String[] nodeNames;
    private JawaaGraphNode[] myNodes;


}
