/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------*/
package jawaa.command;

import java.util.*;
import jawaa.util.*;
import jawaa.anim.*;
import jawaa.object.JawaaObject;


public abstract class JawaaCommand extends JawaaActionPerformer implements Runnable
{
    public JawaaCommand (String kind)
    {
	myKind = kind;
	myData = JawaaHash.getInstance();
    }

    public void setData()
    {
    }

    public void execute ()
    {}

    public abstract boolean step ();

    public void run ()
    {
	long tm = System.currentTimeMillis();

	while (! AnimController.isStopped() && step())
	{
	    try
	    {
		tm += myDelay;
		fireActionPerformed();
		Thread.sleep(Math.max(0, tm - System.currentTimeMillis()));
	    }
	    catch (Exception e)
	    {
		System.out.println("Thread sleep error: "+e);
	    }
	}
 
	fireActionCompleted();
    }


    public String getTarget ()
    {
	return myTarget;
    }

    public String toString()
    {
	return myKind;
    }

    protected JawaaHash myData;
    protected String myTarget;
    protected String myKind;
    protected int myDelay = 50;
}
