/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------*/
package jawaa.anim;

import jawaa.object.JawaaObject;
import java.awt.*;
import jawaa.util.*;


public class ObjectMover implements Runnable
{
    public ObjectMover(JawaaObject obj, Point destination, int iter,
		       JawaaListener listen)
    {
	myObject = obj;
	int[] start = new int[2];
	int[] end = new int[2];

	start[0]=obj.getLocation().x;
	start[1]=obj.getLocation().y;

	end[0]=destination.x - obj.getLocation().x;
	end[1]=destination.y - obj.getLocation().y;

	myProgress = new AnimProgression(start, end, iter);
	myListen = listen;
	
    }

    public void run()
    {
	long tm  = System.currentTimeMillis();
	
	while(!myProgress.complete && AnimController.isRunning())
	{
	    try{
		int[] offset = myProgress.step();
		myObject.setLocation(offset[0], offset[1]);
	    }
	    catch(NullPointerException e){
		ErrorHandler.error(this, "animation error", e, true);
	    }
	    myListen.actionPerformed();
	    try{
		tm += myDelay;
		Thread.sleep(Math.max(0,
				      tm-System.currentTimeMillis()));
	    }
	    catch(Exception e){
		System.out.println("ObjectMover interrupted.");
	    }
	}

	myListen.actionCompleted();
    }

    public String toString()
    {
	return "ObjectMover";
    }

    protected int myDelay = 50;
    private JawaaListener myListen;
    private AnimProgression myProgress;
    private JawaaObject myObject;
    
}
