/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------
File:                           Interpreter.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:       
The Interpreter is the class that handles file reading and then
command/object generation.  The Interpreter uses the CommandFactory in
order to parse Jawaa anim files and return the appropriate object.
-------------------------------------------------------------------------------*/
package jawaa.util;

import java.io.*;
import jawaa.command.*;
import jawaa.util.Iterator;
import jawaa.util.ErrorHandler;


public class Interpreter implements Iterator
{
    public Interpreter (BufferedReader script)
    {
	myCommands = new CommandFactory();
        myReader = script;
        init();
	myInstance = this;
    }

    public static Interpreter getInstance ()
    {
        return myInstance;
    }
    

    public void init ()
    {
        try
        {
	    myLine = getNextNonCommentLine(myReader);
        }
        catch (IOException e)
	{
            // notify Error Handler
        }
    }

    public boolean hasNext ()
    {
        return (myLine != null);
    }

    public Object next ()
    {
	Object result = null;

        try
        {
	    // should be non-null
	    myCurrentLine = myLine;
	    System.out.println(myCurrentLine);

	    if (myCurrentLine.equals("begin"))
	    {
		result = buildBeginEnd();
	    }
	    else
	    {
		result = myCommands.getCommand(myCurrentLine);
	    }

	    myLine = getNextNonCommentLine(myReader);
	    return result;
        }
        catch (IOException e)
        {
            ErrorHandler.error(Interpreter.getInstance(), "file read error");
	    return null;
        }
    }

    protected boolean containsAlphaNumeric (String s)
    {
        byte[] c = s.getBytes();

        for (int i = 0; i < c.length; i++)
        {
            if (c[i] > 48) return true;
        }

        return false;
    }

    public BeginEndCommand buildBeginEnd ()
    {
	try
        {
	    BeginEndCommand result = new BeginEndCommand();
	    
	    String line = getNextNonCommentLine(myReader);
	    while (line != null && (! line.equals("end")))
	    {
		result.add(myCommands.getCommand(line));
		System.out.println(line);
		line = getNextNonCommentLine(myReader);
            }

	    // assume EOF is same as end
	    System.out.println("end");
	    return result;
	}
	catch (IOException e)
	{
	    // Notify Error Handler
	    return null;
	}
    }

    public void remove ()
    {
        // needed for Iterator interface, java 1.2
    }

    public String getCurrentLine ()
    {
        return myCurrentLine;
    }

    public int getCurrentLineNumber ()
    {
        return myLineNumber;
    }

    public String toString ()
    {
        return("Interpreter");
    }


    private String getNextNonCommentLine (BufferedReader reader) throws IOException
    {
	String line = null;

	do
	{
	    myLineNumber++;
	    line = reader.readLine();
	    if (line != null)
	    {
		line = line.trim();
	    }
	    else
	    {
		return null;
	    }
	}
	while (line.startsWith("#") || !containsAlphaNumeric(line));

        return line;
    }


    private BufferedReader myReader;
    private String myLine;
    private String myCurrentLine;
    private int myLineNumber = 0;
    private CommandFactory myCommands;
    private static Interpreter myInstance;
}
