/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*-------------------------------------------------------------------------------
File:                           ColorFactory.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
Follows the factory design pattern in order to interpret and convert a
string representation of a color into a Color object. The string can
either be a color name or an rgb triplet.
---------------------------------------------------------------------------------*/
package jawaa.util;

import java.awt.Color;


public class ColorFactory
{
    private ColorFactory ()
    {
    }

    public static Color getColor (String s)
    {
	s = s.toLowerCase();
	if (s.equals("black"))
	    return Color.black;
	else if(s.equals("blue"))
	    return Color.blue;
	else if(s.equals("cyan"))
	    return Color.cyan;
	else if(s.equals("darkgray"))
	    return Color.darkGray;
	else if(s.equals("gray"))
	    return Color.gray;
	else if(s.equals("green"))
	    return Color.green;
	else if(s.equals("lightgray"))
	    return Color.lightGray;
	else if(s.equals("magenta"))
	    return Color.magenta;
	else if(s.equals("orange"))
	    return Color.orange;
	else if(s.equals("pink"))
	    return Color.pink;
	else if(s.equals("red"))
	    return Color.red;
	else if(s.equals("white"))
	    return Color.white;
	else if(s.equals("yellow"))
	    return Color.yellow;
	else if(s.equals("transparent"))
	    return new Color(-5544);
	else if(s.equals("brown"))
	    return new Color(165,42,42);
	else if(s.equals("wheat"))
	    return new Color(245,222,179);
	else if (s.equals("aqua"))
	    return new Color(127,255,212);
	else if (s.equals("violet"))
	    return new Color(148,0,211);
	else if (s.equals("darkorange"))
	    return new Color(255,140,0);
	else if (s.equals("deeppink"))
	    return new Color(255,20,147);
	else if (s.equals("darkgreen"))
	    return new Color(0,128,0);
	else
	{
	    Color c = getRGB(s);
	    if(c == null)
	    {
		ErrorHandler.error(new ColorFactory(), "no such color.", true);
		return null;
	    }
	    else return c;
	}
    }

    public static Color getRGB(String color)
    {
	try{
	    StringParser parse = null;
	    if(color.startsWith("(") && color.endsWith(")"))
		parse = new
		    StringParser(color.substring(1,color.length()-1),",");
	    
	    else
		parse = new StringParser(color, ",");
	    int[] rgb = new int[parse.countTokens()];
	    // parse.init();
	    for(int i=parse.countTokens()-1; i>=0; i--)
	    {
		rgb[i] = Integer.parseInt(parse.nextToken());
	    }
	    
	    return new Color(rgb[2], rgb[1], rgb[0]);
	}
	catch(NumberFormatException e){
	    ErrorHandler.error(new ColorFactory(), "syntax error in RGB color",e,false);
	}
	catch(ArrayIndexOutOfBoundsException e){
	    ErrorHandler.error(new ColorFactory(), "syntax error in RGB color",e,false);
	}
	return null;
    }
    
    public String toString()
    {
	return("ColorFactory");
    }
}
