/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
                                
-------------------------------------------------------------------------------*/
package jawaa.structure;


public class Queue
{
    public Queue ()
    {}

    public void enqueue(Object o)
    {
	myNode = new ListNode(o, myNode);
    }
    
    public Object dequeue()
    {
	ListNode temp = myNode;
	try{
	    if(temp.myNext == null)
	    {
		Object o = temp.myData;
		temp = null;
		return o;
	    }
	    else{
		while(temp.myNext.myNext != null)
		    temp = temp.myNext;
		Object o = temp.myNext.myData;
		temp.myNext = null;
		return o;
	    }

	}
	catch(NullPointerException e){
	    //do nothing, myNode is already null
	}
	return null;
    }
    

    public void addElement(Object o)
    {
	ListNode temp = myNode;
	try{
	    while(temp.myNext != null)
	    {
		temp = temp.myNext;
	    }
	    temp.myNext = new ListNode(o);
	}
	catch(NullPointerException e){
	    myNode = new ListNode(o);
	}
    }

    public void init()
    {
	myIterator = myNode;
    }

    public boolean hasNext()
    {
	return myIterator != null;
    }

    public Object next()
    {
	Object temp = myIterator.myData;
	myIterator = myIterator.myNext;
	return temp;
    }
    
    private ListNode myNode = null;
    private ListNode myIterator = null;
}
