/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
                                
-------------------------------------------------------------------------------*/
package jawaa.structure;

import jawaa.object.*;
import jawaa.util.*;
import java.awt.*;
import java.util.*;
import jawaa.anim.AnimController;

public class JawaaStack extends JawaaContainer
{
    public JawaaStack(String[] args)
    {
	super(args);
    }

    public void build(String[] args)
	throws ArrayIndexOutOfBoundsException, NumberFormatException,
	       NullPointerException
    {
	myStack = new Stack();
	myFontMetrics = AnimController.getFontMetrics();

	myLocation = new Point(Integer.parseInt(args[2]),
			       Integer.parseInt(args[3]));
	myLength = Integer.parseInt(args[4]);
	String[] temp = new String[myLength];

	int i = 5;
	for(; i < myLength+5; i++)
	{
	    if(myFontMetrics.stringWidth(args[i]) > myLongest)
		myLongest = myFontMetrics.stringWidth(args[i]);
	    temp[i-5] = args[i];
	}
	setColor(args[i]);
	i++;
	setTextColor(args[i]);
	setBackground(args[i]);
	initStack(temp);
    }
    
    private void updateLocation()
    {
	for(int i = myStack.size()-1; i>=0; i--)
	{
	    JawaaText text = (JawaaText)myStack.elementAt(i);
	    int length = myFontMetrics.stringWidth(text.getText());
	    int leftover_space = (int)Math.rint((MYBUFFER*2+myLongest -
				     length)/2.0);
	    int x = myLocation.x+leftover_space;
	    int y = myLocation.y + (myStack.size()-i)*myFontMetrics.getMaxAscent()
		+ (myStack.size()-i-1)*myFontMetrics.getMaxDescent();
	    
	    Point location = new Point(x,y);
	    text.setLocation(x,y);
	}
    }
    
    private void initStack(String[] values)
    {
	for(int i = values.length-1; i>=0; i--)
	{
	    int length =
		myFontMetrics.stringWidth(values[i]);
	    int leftover_space = (int)Math.rint((MYBUFFER*2+myLongest -
				     length)/2.0);
	    int x = myLocation.x+leftover_space;
	    int y = myLocation.y + (1+i)*myFontMetrics.getMaxAscent()
		+ i*myFontMetrics.getMaxDescent();
	    
	    Point location = new Point(x,y);

	    myStack.push(new JawaaText(values[i], location, myTextColor));
	}
    }
	
    public void paint(Graphics g)
    {
	g.setColor(myColor);
	g.drawLine(myLocation.x-MYBUFFER, myLocation.y, myLocation.x,
		   myLocation.y);
	int height = myStack.size() * (myFontMetrics.getMaxAscent() +
				       myFontMetrics.getMaxDescent());
	int width = (2*MYBUFFER) + myLongest;
	g.drawLine(myLocation.x, myLocation.y, myLocation.x,
		   myLocation.y+height);
	g.drawLine(myLocation.x, myLocation.y+height,
		   myLocation.x+width,
		   myLocation.y+height);
	g.drawLine(myLocation.x+width, myLocation.y,
		   myLocation.x+width, myLocation.y+height);
	g.drawLine(myLocation.x+width, myLocation.y,
		   myLocation.x+width+MYBUFFER, myLocation.y);
	
	
	super.paint(g);
    }

    public JawaaObject get(int i)
    {
	return (JawaaObject)myStack.elementAt(i);
    }

    public void push(String s)
    {
	int length = myFontMetrics.stringWidth(s);
	if(length>myLongest)
	    myLongest = length;
	myStack.push(new JawaaText(s, new Point(0,0), myTextColor));
	updateLocation();
    }

    public int findLongest()
    {
	int length = 0;
	if(myStack.size() == 0)
	    return 10;
	for(int i=0;i<myStack.size();i++)
	{
	    int temp =
		myFontMetrics.stringWidth(((JawaaText)myStack.elementAt(i)).getText());
	    
	    if(temp > length)
		length = temp;
	}
	return length;
    }

    public void pop()
    {
	JawaaText temp = (JawaaText)myStack.pop();
	if(myFontMetrics.stringWidth(temp.getText()) >= myLongest)
	    myLongest = findLongest();
	updateLocation();
    }

    public void add(String s)
    {
	push(s);
    }
    
    public void init()
    {
	myIndex = 0;
    }

    public Object next()
    {
	return myStack.elementAt(myIndex++);
    }

    public boolean hasNext()
    {
	return (myIndex < myStack.size());
    }

    public void setColor(Color c)
    {
	myColor = c;
    }

    public void setBackground(Color c)
    {
	myBackground = c;
    }
    
        public void setTextColor(String color)
    {
	setTextColor(ColorFactory.getColor(color));
    }

    public void setTextColor(Color c)
    {
	super.setTextColor(c);
	init();
	while(hasNext())
	{
	   try{
	       ((JawaaObject)next()).setTextColor(c);
	    }
	    catch(ClassCastException e){
		
	    }
	}
    }
    
    public Color getTextColor()
    {
	return myTextColor;
    }
    



    private int myLength = 0;
    private int myIndex = 0;
    protected java.util.Stack myStack;
    private int myLongest;
    private FontMetrics myFontMetrics;
    private final int MYBUFFER = 4;
}
