/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*-------------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
                                
----------------------------------------------------------------------------------*/
package jawaa.object;

import java.awt.*;
import jawaa.anim.AnimController;
import jawaa.util.*;

public class JawaaText extends JawaaObject implements Scalable
{
    public JawaaText (String[] args)
    {
	super(args);
    }

    public JawaaText (String s, Point p, Color color)
    {
	Font f = AnimController.getFontMetrics().getFont();
	myText = s;
	myLocation = p;
	myColor = color;
	mySize = f.getSize();
    }

    public void build (String[] args) throws
        ArrayIndexOutOfBoundsException, NumberFormatException, Exception
    {
	Font f = AnimController.getFontMetrics().getFont();
	mySize = f.getSize();
	setLocation(Integer.parseInt(args[2]),
		    Integer.parseInt(args[3]));
	myText = args[4];
	setColor(args[5]);
	if (args.length > 6)
	{
	    mySize = Integer.parseInt(args[6]);
	}
	else
	    mySize = f.getSize(); 

    }
 
    public void paint (Graphics g)
    {
	Font f = g.getFont();
	if (f.getSize() != mySize)
	    f = new Font(f.getName(), f.getStyle(), mySize);
	g.setFont(f);
	if (myColor.getRGB() != -5544)
        {
	    g.setColor(myColor);
	    g.drawString(myText, myLocation.x, myLocation.y);
	}
    }

    public void setSize (int[] size)
    {
	mySize = size[0];
	changed = true;
    }

    public void setSize (int size)
    {
	mySize = size;
	changed = true;
    }

    public int[] getSize ()
    {
	int[] ret = {mySize};
	return (ret);
    }
    
    public void setText (String s)
    {
	myText = s;
	changed = true;
    }
    
    public void setTextColor(String s)
    {
	Color c = ColorFactory.getColor(s);
	myColor = c;
	changed = true;
    }

    public void setTextColor(Color color)
    {
	myColor=color;
    }

    public Color getTextColor()
    {
	return myColor;
    }
 

    public String getText ()
    {
	return myText;
    }

    public String toString ()
    {
	return myText;
    }

    protected FontMetrics changeFont (int size)
    {
	Font f = AnimController.getFontMetrics().getFont();
	if (size != f.getSize())
	{
	    return Toolkit.getDefaultToolkit().getFontMetrics(
	        new Font(f.getName(), f.getStyle(), size));
	}
	else
	{
	    return AnimController.getFontMetrics();
	}
    }

    public int getMaxAscent ()
    {
	FontMetrics metric = changeFont(mySize);
	return metric.getMaxAscent();
    }

    public int getMaxDescent ()
    {
	FontMetrics metric = changeFont(mySize);
	return metric.getMaxDescent();
    }

    public int getHeight ()
    {
	return getMaxDescent() + getMaxAscent();
    }

    public int stringWidth ()
    {
	FontMetrics metric = changeFont(mySize);
	return metric.stringWidth(myText);
    }


    private int mySize;
    private String myText;
    private final String NUMBER_EXCEPTION = "invalid location";
    public boolean changed = false;
}
