/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
                                
-------------------------------------------------------------------------------*/
package jawaa.object;

import java.awt.Color;
import java.awt.Point;
import jawaa.util.ColorFactory;


public abstract class JawaaShape extends JawaaObject
{
    public JawaaShape ()
    {}

    public JawaaShape (String[] args)
    {
	super(args);
    }


    public void setBackground (String color)
    {
	myBackground = ColorFactory.getColor(color);
    }

    public void setBackground (Color color)
    {
	myBackground = color;
    }

    public Color getBackground ()
    {
	return myBackground;
    }
   
    public Point getCenter ()
    {
	return new Point(myLocation.x + myWidth / 2,
			 myLocation.y + myHeight / 2);
    }

    public void setCenterLocation (int x, int y)
    {
	if (myLocation != null)
	{
	    setLocation(x - myWidth / 2, y - myHeight / 2);
	}
	else
	{
	    myLocation = new Point(x - myWidth / 2, y - myHeight / 2);
	}
    }
    public void setCenterLocation (Point p)
    {
	setCenterLocation(p.x, p.y);
    }

    public int getWidth ()
    {
	return myWidth;
    }

    public void setWidth (int width)
    {
	myWidth = width;
    }


    public int getHeight ()
    {
	return myHeight;
    }

    public void setHeight (int height)
    {
	myHeight = height;
    }

    protected int myWidth;
    protected int myHeight;
    protected Color myBackground;
   
}
