/*-------------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

-------------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------------*/
package jawaa.object;

import java.awt.*;
import jawaa.util.ColorFactory;
import jawaa.structure.MultiPointContainer;


public class JawaaPolygon extends JawaaShape implements MultiPointContainer
{
    public JawaaPolygon (String[] args)
    {
	super(args);
    }
    
    public void build (String[] args) throws
        ArrayIndexOutOfBoundsException, NumberFormatException, Exception
    {
	int numVertices = Integer.parseInt(args[2]);
	myXPoints = new int[numVertices];
	myYPoints = new int[numVertices];

	int minX = Integer.MAX_VALUE;
	int maxX = 0;
	int minY = Integer.MAX_VALUE;
	int maxY = 0;
	int i = 0;
	for( ; i < numVertices; i++)
	{
	    myXPoints[i] = Integer.parseInt(args[(2 * i) + 3]);
	    if (myXPoints[i] < minX) minX = myXPoints[i];
	    if (myXPoints[i] > maxX) maxX = myXPoints[i];
	    myYPoints[i] = Integer.parseInt(args[(2 * i) + 4]);
	    if (myYPoints[i] < minY) minY = myYPoints[i];
	    if (myYPoints[i] > maxY) maxY = myYPoints[i];
	}
	setLocation(minX, minY);
	setHeight(maxY - minY);
	setWidth(maxX - minX);

	i = i * 2 + 3;
	setColor(args[i]);
	i++;
        // assume same color if they left it off
	setBackground((args.length == i + 1) ? args[i] : args[i - 1]);
    } 

    public void paint (Graphics g)
    {
	if (myBackground.getRGB() != -5544)
	{ 
	    g.setColor(myBackground);
	    g.fillPolygon(myXPoints, myYPoints, myXPoints.length);
	}
	if (myColor.getRGB() != -5544)
        {
	    g.setColor(myColor);
	    g.drawPolygon(myXPoints, myYPoints, myXPoints.length);
	}
    }

    public void offsetLocation (int x, int y)
    {
	for (int i = 0; i < myXPoints.length; i++)
	{
	    myXPoints[i] += x;
	    myYPoints[i] += y;
	}
	myLocation.x += x;
	myLocation.y += y;
    }

    public void setLocation (int x, int y, int k)
    {
	myXPoints[k] = x;
	myYPoints[k] = y;
    }

    public Point getLocation (int k)
    {
	return new Point(myXPoints[k], myYPoints[k]);
    }

    public Point getCenter ()
    {
	Point result = new Point(0, 0);

	for (int i = 0; i < myXPoints.length; i++)
	{
	    result.x += myXPoints[i];
	    result.y += myYPoints[i];
	}

	result.x /= myXPoints.length;
	result.y /= myXPoints.length;
	return result;
    }


    private int[] myXPoints;
    private int[] myYPoints;
    private final String NUMBER_EXCEPTION = "invalid point";
}
