/*------------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

-------------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------------*/
package jawaa.object;

import java.awt.*;
import jawaa.util.*;


public abstract class JawaaObject implements Drawable
{
    public JawaaObject ()
    {}

    public JawaaObject (String[] args)
    {
	try
	{
	    // try to determine if they forgot the name of the object
	    if (Character.isJavaIdentifierStart(args[1].charAt(0)))
	    {
		myName = args[1];
		build(args);
	    }
	    else
	    {
		myName = "ERROR";
		ErrorHandler.error(this, "no name given for object", true);
	    }
	}
	catch (ArrayIndexOutOfBoundsException e)
	{
	    ErrorHandler.error(this, "not enough arguments to complete command", true);
	}
	catch (NumberFormatException e)
	{
	    ErrorHandler.error(this, NUMBER_EXCEPTION, true);
	}
	catch (Exception e)
	{
	    e.printStackTrace();
	    ErrorHandler.error(this, "syntax error ", e, true);
	}
    }


    /**
     * Function that is called by the constructor in order to initial
     * state of an object.  This function should be overriden by
     * subclasses of JawaaObject and used to set up private variables.
     */
    public void build (String[] args) throws Exception
    {
    }

    public abstract void paint(Graphics g);
//    public abstract void scale(int percent);
    
    public void setColor (String color)
    {
	myColor = ColorFactory.getColor(color);
    }

    public void setColor (Color color)
    {
	myColor = color;
    }
    
    public Color getColor ()
    {
	return myColor;
    }

      public void setTextColor (String color)
    {
	myTextColor = ColorFactory.getColor(color);
    }

    public void setTextColor (Color color)
    {
	myTextColor = color;
    }

    public Color getTextColor ()
    {
	return myTextColor;
    }

    public Point getLocation ()
    {
	return myLocation;
    }
    
    public void setLocation (int x, int y)
    {
	if (myLocation != null)
	    offsetLocation(x - myLocation.x, y - myLocation.y);
	else
	    myLocation = new Point(x, y);
    }

    public void offsetLocation (int x, int y)
    {
	myLocation.x += x;
	myLocation.y += y;
    }

    public String getName ()
    {
	return myName;
    }

    public String toString ()
    {
	return myName;
    }

    public void destroy ()
    {
    }

    public boolean equals (JawaaObject obj)
    {
	return (myName.equals(obj.getName()));
    }


    protected String myName;
    protected Color myColor;
    protected Color myTextColor;
    protected Point myLocation;
    protected String NUMBER_EXCEPTION = "syntax error, number expected";
}
