/*-----------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

-------------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
                                
-------------------------------------------------------------------------------*/
package jawaa.object;

import java.awt.Graphics;
import java.util.Vector;
import java.awt.Point;
import jawaa.util.JawaaHash;
import jawaa.util.ErrorHandler;


public class JawaaGroupObject extends JawaaObject
{
    public JawaaGroupObject (String[] args)
    {
	super(args);
	myLocation = new Point(0,0);
    }

    public JawaaGroupObject (String name, String[] objs)
    {
	myName = name;
	myTargets = new Vector();
	for (int i = 0; i < objs.length; i++)
	{
	    myTargets.addElement(objs[i]);
	}
	myLocation = new Point(0,0);
    }

    public void build (String[] args) throws
        ArrayIndexOutOfBoundsException, NumberFormatException, NullPointerException
    {
	int num = Integer.parseInt(args[2]);
	myTargets = new Vector();
	for (int i = 0; i < num; i++)
	{
	    myTargets.addElement(args[i + 3]);
	}

	if (args.length > num + 3)
	{
	    ErrorHandler.error(this, "number of objects does not equal " + num);
	}
    }

    public void offsetLocation (int x, int y)
    {
	super.offsetLocation(x, y);

        JawaaHash hash = JawaaHash.getInstance();
	for (int i = 0; i < myTargets.size(); i++)
	{
	    ((JawaaObject)hash.get(myTargets.elementAt(i))).offsetLocation(x,y);
	}
    }

    public void setLocation (int x, int y)
    {
	offsetLocation(x - myLocation.x, y - myLocation.y);
	myLocation.x = x;
	myLocation.y = y;
    }

    public Vector getTargets()
    {
	return myTargets;
    }

    /*public Vector getBackgrounds()
    {
	for (int i=0; i<myTargets.size(); i++)
	{
	    myBackgrounds.addElement((myTargets.elementAt(i)).getColor());
	}
	return myBackgrounds;
	}*/
    
    public void add (JawaaObject o)
    {
	myTargets.addElement(o.getName());
    }

    public void add (String s)
    {
	myTargets.addElement(s);
    }

    public void remove (JawaaObject o)
    {
	myTargets.removeElement(o.getName());
    }

    public void remove (String s)
    {
	myTargets.removeElement(s);
    }

    public void paint (Graphics g)
    {
	// grouped objects already painted themselves
    }


    //private Vector myTargets;
    public Vector myTargets;
    public String[] myBackgrounds;
}
