/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           TreeCommand.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------*/
package jawaa.command;

import java.awt.*;
import jawaa.layout.RootedTreeEngine;
import jawaa.util.*;
import jawaa.structure.*;
import jawaa.extras.arrow.*;


public class TreeCommand extends JawaaCommand
{
    public TreeCommand(String[] args)
    {
	super("Tree");
	try
	{
	    myName = args[1];
	    myLocation = new Point();
	    myLocation.x = Integer.parseInt(args[2]);
	    myLocation.y = Integer.parseInt(args[3]);
	    myWidth = Integer.parseInt(args[4]);
	    myRoot = args[5];
	    int num = Integer.parseInt(args[6]);
	    int i = 7;
	    nodes = new TreeConnection[num];
	    for(int j = 0; j < nodes.length; j++)
	    {
		nodes[j] = new TreeConnection(args[i++]);
	    }

	    myColor = ColorFactory.getColor(args[i++]);
	    myBackground = ColorFactory.getColor(args[i++]);
	}
	catch(NumberFormatException e){
	    ErrorHandler.error(this, "syntax error ", e, true);
	}
	catch(ArrayIndexOutOfBoundsException e){
	    ErrorHandler.error(this, "syntax error ", e, true);
	}
       
    }

    public boolean step ()
    {
	JawaaTreeNode node = (JawaaTreeNode)myData.get(myRoot);
	if(node == null)
	    System.out.println("NULLLLLLLL");
	
	RootedTreeEngine.layout(node, myLocation, 0);

	return false;
    }

    
   public void setData()
    {
	for(int i = 0; i<nodes.length; i++)
	{
	    JawaaTreeNode first = getNode(nodes[i].parentNode, myData);
	    if(first != null)
	    {
		addChild(first, nodes[i], myData);
	    }
	}
    }


    private void addChild(JawaaTreeNode parent, TreeConnection c, JawaaHash hash)
    {
	String left = c.getLeft();
	String right = c.getRight();
	if(left != null)
	{
	    JawaaTreeNode l = getNode(left, hash);
	    if(l != null)
	    {
		SmartArrow arrow = parent.addLeftChild(l, myColor);
		String name = parent.getName()+"_to_"+l.getName();
		arrow.setName(name);
		hash.put(name, arrow);
	    }
	
	}
	if(right != null)
	{
	    JawaaTreeNode r = getNode(right, hash);
	    if(r != null)
	    {
		SmartArrow arrow = parent.addRightChild(r, myColor);
		String name = parent.getName()+"_to_"+r.getName();
		arrow.setName(name);
		hash.put(name, arrow);
	    }
	}
    }

    private JawaaTreeNode getNode(String name, JawaaHash hash)
    {
	Object node = hash.get(name);
	if(node == null)
	{
	    JawaaTreeNode temp = buildNewNode(name);
	    hash.put(name, temp);
	    return temp;
	}
	if(node instanceof JawaaTreeNode)
	    return (JawaaTreeNode)node;
	else if(node instanceof JawaaGraphNode)
	{
	    hash.remove(name);
	    JawaaTreeNode temp = new JawaaTreeNode((JawaaNode)node);
	    hash.put(name, temp);
	    return temp;
	}
	else
	{
	    ErrorHandler.error(this, name +" does not refer to a legal node");
	    return null;
	}
    }
    
    private JawaaTreeNode buildNewNode(String name)
    {
	String[] s = new String[1];
	s[0] = name;
	return new JawaaTreeNode(name,
				 myColor, myBackground,
				 s, myLocation.x,
				 myLocation.y, myWidth,
				 myWidth);
    }


    private TreeConnection[] nodes;
    private int myWidth;
    private Point myLocation;
    private String myName;
    private Color myColor;
    private Color myBackground;
    private String myRoot;
    private String[] myUniqueNodes;

    
    class TreeConnection
    {
	public TreeConnection(String s)
	{
	    childNodes = new String[2];
	    s =
		s.substring(s.indexOf('(')+1,s.indexOf(')')-s.indexOf('('));
	    if(isValid(s))
	    {
		try{
		    int j = s.indexOf(',');
		    parentNode = s.substring(0, j);
		    if(j+1 == s.indexOf(',', j+1))
			childNodes[0] = null;
		    else
		    {
			childNodes[0] = s.substring(j+1,
						    s.indexOf(',',j+1));
		    }
		    j = s.indexOf(',',j+1);
		    if(j+1 == s.length())
			childNodes[1] = null;
		    else
		    {
			childNodes[1] = s.substring(j+1);
		    }
		    
		}
		catch(Exception e)
		{
		    System.out.println("error in TreeConnection construct");
		}
	    }
	}
	
	public TreeConnection(String s, String l, String r)
	{
	    childNodes = new String[2];
	    parentNode = s;
	    childNodes[0] = l;
	    childNodes[1] = r;
	}

	public String getLeft()
	{
	    return childNodes[0];
	}

	public String getRight()
	{
	    return childNodes[1];
	}

	private boolean isValid(String s)
	{
	    int comma = 0;
	    try{
		for(int i=0 ; i<s.length(); i++)
		{
		    if(s.charAt(i) == ',')
			comma++;
		}
		if(comma == 2)
		    return true;
		else return false;
	    }
	    catch(StringIndexOutOfBoundsException e){
		System.out.println("error in treeconnection");
	    }
	    return false;
	}
	
	public String parentNode;
	public String[] childNodes;
    }
}
