/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------*/
package jawaa.anim;

import java.awt.Color;
import jawaa.object.*;
import jawaa.util.*;
import jawaa.structure.*;

public class ColorMorpher implements Runnable
{
    public ColorMorpher(Color begin, Color end, JawaaObject object,
			JawaaListener listen, int type)
    {
	myType = type;
	myListen = listen;
	myStartRed = begin.getRed();
	myStartBlue = begin.getBlue();
	myStartGreen = begin.getGreen();
	myTargetRed = end.getRed();
	myTargetBlue = end.getBlue();
	myTargetGreen = end.getGreen();
	myObj = object;
	int[] offsets = new int[3];
	offsets[0] = myTargetRed - myStartRed;
	offsets[1] = myTargetBlue - myStartBlue;
	offsets[2] = myTargetGreen - myStartGreen;
	int[] initial = new int[3];
	initial[0] = myStartRed;
	initial[1] = myStartBlue;
	initial[2] = myStartGreen;
	myProgress = new AnimProgression(initial,offsets);
	newRed = myStartRed;
	newBlue = myStartBlue;
	newGreen = myStartGreen;
    }

    public void run ()
    {
	long tm = System.currentTimeMillis();
	while (!myProgress.complete)
	{
	    int[] delta = myProgress.step();
	    newRed =delta[0];
	    newBlue =delta[1];
	    newGreen =delta[2];
	    try{
		if(myType == FOREGROUND)
		    myObj.setColor(new Color(newRed, newGreen, newBlue));
		if(myType == BACKGROUND)
		{
		    if (myObj instanceof JawaaShape)
		    ((JawaaShape)myObj).setBackground(new Color(newRed,
								newGreen,
								newBlue));
		}

		if(myType==TEXTCOLOR)
		{
		    if (myObj instanceof JawaaContainer)
		    {
			((JawaaContainer)myObj).setTextColor(new Color(newRed, 
								       newGreen, 
								       newBlue));
		    }
		    else 
		    {
			try {
			    ((JawaaText)myObj).setTextColor(new Color(newRed, 
								      newGreen, 
								      newBlue));
			}
			catch(Exception e) {
			    ((JawaaNode)myObj).setTextColor(new Color(newRed, 
								      newGreen, 
								      newBlue));
			}
		    }
		}
		if(myType==ARROWCOLOR)
		    myObj.setColor(new Color(newRed, newGreen, newBlue));
	    }
	    catch(Exception e)
	    {
		ErrorHandler.error(this, "this object has no background", e, true);		
	    }
	    myListen.actionPerformed();
	    try
	    {
		tm+=myDelay;
		Thread.sleep(Math.max(0,tm-System.currentTimeMillis()));
	    }
	    catch(Exception e)
	    {
		System.out.println("ColorThread interrupted");
	    }
	}
	myListen.actionPerformed();
	myListen.actionCompleted();
    }

    public String toString()
    {
	return ("ColorMorpher");
    }

    protected int myDelay = 50;
    private int myType = 0;
    private JawaaListener myListen;
    private AnimProgression myProgress;
    private int myStartRed;
    private int myStartBlue;
    private int myStartGreen;
    private int myTargetRed;
    private int myTargetBlue;
    private int myTargetGreen;
    private int newRed;
    private int newBlue;
    private int newGreen;
    private JawaaObject myObj;

    public static final int BACKGROUND = 0;
    public static final int FOREGROUND = 1;
    public static final int TEXTCOLOR  = 2;
    public static final int ARROWCOLOR = 3;
}
