/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------*/
package jawaa.anim;

import java.awt.*;


public class AnimController
{
    public AnimController (AnimationCanvas canvas)
    {
	this.canvas = canvas;
	ourSpeed = 50;
    }


    public static void start ()
    {
	ourPaused = false;
	ourRunning = true;
    }

    public static boolean isRunning ()
    {
	return (ourPaused == false) && (ourRunning == true);
    }

    public static void pause ()
    {
	ourPaused = true;
	ourRunning = true;
    }

    public static boolean isPaused ()
    {
	return (ourPaused == true) && (ourRunning == true);
    }

    public static void stop ()
    {
	ourPaused = true;
	ourRunning = false;
    }

    public static boolean isStopped ()
    {
	return (ourPaused == true) && (ourRunning == false);
    }


    public static void setSpeed (int sliderSpeed)
    {
	// for slider, faster = larger
	// for timer, faster = smaller
	ourSpeed = 100 - sliderSpeed;
    }

    public static int getSpeed ()
    {
	return ourSpeed;
    }

    public static FontMetrics getFontMetrics ()
    {
	return canvas.getFontMetrics();
	//return ourMetrics;
    }


    private static boolean ourPaused = false;
    private static boolean ourRunning = false;    
    private static AnimationCanvas canvas;
    private static FontMetrics ourMetrics;
    private static int ourSpeed;
}
