/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------
File:                           ErrorHandler.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
This class collects error messages from different JawaaCommand objects
during the processing of a particular Jawaa script. The errors can be
displayed either in an error frame or to the console.
------------------------------------------------------------------------------*/
package jawaa.util;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import jawaa.anim.AnimController;

public class ErrorHandler extends Frame
{
    protected ErrorHandler ()
    {
	super("Jawaa Error Reporting");
	setSize(300,300);
	add(myText);
	addWindowListener(new CloseWindow());
    }

    public static ErrorHandler getInstance ()
    {
	if(myInstance == null)
	{
	    myInstance = new ErrorHandler();
	}
	return myInstance;
    }

    private static String getLine ()
    {
	return Interpreter.getInstance().getCurrentLine();
    }

    private static int getLineNum ()
    {
	return Interpreter.getInstance().getCurrentLineNumber();
    }
    
    public static void error (Object o, String s, Exception e, boolean fatal)
    {
	String err = o + ": " + s + " resulted in " + e.toString();
	ErrorObject obj = new ErrorObject(getLine(), getLineNum(), err);
	ErrorHandler.getInstance().reportError(obj);
	if (fatal)
	{
	    AnimController.stop();
	}
    }

    public static void error (Object o, String s, boolean fatal)
    {
	String err = o + ": " + s + " ";
	ErrorObject obj = new ErrorObject(getLine(), getLineNum(), err);
	ErrorHandler.getInstance().reportError(obj);
	if (fatal)
	{
	    AnimController.stop();
	}
    }
  
    
    public static void error (Object o, String s)
    {
	String err = o + ": " + s + " ";
	ErrorObject obj = new ErrorObject(getLine(), getLineNum(), err);
	ErrorHandler.getInstance().reportError(obj);
    }

    protected void reportError (ErrorObject s)
    {
	myErrors.addElement(s);
	myText.append(s + "\n\n");
	pack();
	setVisible(true);
    }

    public void reset ()
    {
	dispose();
	remove(0);
	myText = new TextArea("", 10, 60);
	add(myText);
    }
    
    private static Vector myErrors = new Vector();
    private static ErrorHandler myInstance = null;
    private TextArea myText = new TextArea(10, 60);


    class CloseWindow extends WindowAdapter
    {
	public CloseWindow()
	{}

	public void windowClosing (WindowEvent e)
	{
	    dispose();
	}
    }
}
