/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           CommandFactory.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
This class follows the factory design pattern and serves up all of the 
Jawaa commands.  The factory inspects the first token in a Jawaa command 
string and determines which object/command to return.
--------------------------------------------------------------------------*/
package jawaa.util;

import java.io.*;
import java.util.StringTokenizer;
import jawaa.command.*;
import jawaa.object.*;
import jawaa.structure.*;
import jawaa.extras.marker.*;


public class CommandFactory
{
    public CommandFactory ()
    {
    }

    public Object getCommand (String line)
    {
	String[] args = parseLine(line);

	int code = isOk(args[0]);
	if (code == -1)
	{
	    ErrorHandler.error(this, "unknown command " + args[0]);
	    return null;
	}
	
	switch (code)
	{
	  case 0:
	    return new JawaaCircle(args);
	  case 1:
	    return new JawaaLine(args);
	  case 2:
	    return new JawaaText(args);
	  case 3:
	    return new JawaaRectangle(args);
	  case 4:
	    return new JawaaPolygon(args);
	  case 5:
	    return new TreeCommand(args);
/*	case 6:
	return new AddNodeCommand(args);*/
	  case 7:
	    return new JawaaNodes(args);
	  case 8:
	    return new ConnectNodesCommand(args);
	  case 9:
	    return new JawaaMarker(args);
	  case 10:
	    return new MoveMarkerCommand(args); 
/*	case 11:
	    return new JawaaGraph(args);
	case 12:
	return new AddEdgeCommand(args);*/
	  case 13:
	    return new JawaaArray(args);
	  case 14:
	    return new JawaaStack(args);
	  case 15:
	    return new PushCommand(args);
	  case 16:
	    return new PopCommand(args);
	  case 17:
	    return new JawaaQueue(args);
	  case 18:
	    return new EnqueueCommand(args);
	  case 19:
	    return new DequeueCommand(args);
/*	case 20:
	    return new BeginCommand(args);
	case 21:
	return new EndCommand(args);*/
	  case 22:
	    return new DelayCommand(args);
	  case 23:
	    return new ChangeParamCommand(args);
	  case 24:
	    return new MoveRelativeCommand(args);
	  case 25:
	    return new JawaaGroupObject(args);
	  case 26:
	    return new DeleteCommand(args);
	  case 27:
	    return new ScaleCommand(args);
	  case 28:
	    return new LinkedListCommand(args);
	  case 29:
	   return new JawaaListPointer(args);
	  //case 30:
	  //  return new ListMoveNext(args);
	  case 31:
	    return new JawaaOval(args);
	  case 32:
	    return new ConnectNodesCommand(args);
	  case 33:
	    return new DeleteCommand(args);
	}

	return null;
    }

    public String toString ()
    {
	return("CommandFactory");
    }

    private String[] parseLine (String line)
    {
	StringParser token = new StringParser(line);
	String[] array = new String[token.countTokens()];

	int i = 0;
	while (token.hasMoreTokens())
	{
	    array[i] = token.nextToken();
	    i++;
	}

	return array;
    }

    private int isOk (String com)
    {
	com = com.toLowerCase();
	for (int i = 0; i < commands.length; i++)
	{
	    if (commands[i].equals(com))
	    {
		return i;
	    }
	}
	return -1;
    }
    
    private static String[] commands =
    {
	"circle",
	"line",
	"text",
	"rectangle",
	"polygon",
	"tree",
	"addnode",
	"node",
	"connectnodes",
	"marker",
	"movemarker",
	"graph",
	"addedge",
	"array",
	"stack",
	"push",
	"pop",
	"queue",
	"enqueue",
	"dequeue",
	"begin",
	"end",
	"delay",
	"changeparam",
	"moverelative",
	"groupobject",
	"delete",
	"scale",
	"list",
	"listpointer",
	"listmovenext",
	"oval",
	"edge",
	"remove"
    };
}
