import java.applet.*;
import java.awt.*;
import java.io.*;
import java.net.*;

public class TestApplet extends Applet
{
    // BUGBUG: move to resources file so no recompile necessary!
    public String SCRIPT_PARAM = "foo";
    public String ECHOER = ""; // http://cgi.cs.duke.edu/~rcd/echo.cgi?url=";

    private int myLineNumber = 0;


    public void init ()
    {
        TextArea viewer = new TextArea(40, 40);
        add(viewer);

        try
        {
            URL script = getAnimScript();
            System.out.println(script);
            BufferedReader reader = new BufferedReader(
                                          new InputStreamReader((InputStream)script.getContent()));

            String line = getNextNonCommentLine(reader);
            while (line != null)
            {
                viewer.append(myLineNumber + "\t" + line + "\n");
                line = getNextNonCommentLine(reader);
            }
        }
        catch (IOException e)
        {
            System.out.println("Error reading script.");
        }
    }


    private String getNextNonCommentLine (BufferedReader reader) throws IOException
    {
	String line = null;

	do
	{
	    line = reader.readLine();
	    myLineNumber++;
	}
	while ((line != null) &&
               (line.trim().startsWith("#") || !containsAlphaNumeric(line.trim())));

        return line;
    }

    private boolean containsAlphaNumeric (String s)
    {
        byte[] c = s.getBytes();

        for (int i = 0; i < c.length; i++)
        {
            if (c[i] > 48) return true;
        }

        return false;
    }

    private URL getAnimScript ()
    {
        String base = getDocumentBase().toString();
        String location = getParameter(SCRIPT_PARAM);
	URL result = null;

        // if none, assume it is named same as html file, but .anim extension
        if (location == null)
        {
            location = base.substring(0, base.lastIndexOf(".")) + ".anim";
        }

        try
        {
            result = new URL(location);
        }
        catch (MalformedURLException e)
        {
            try
            {
		// if not fully specified URL, assume in same location as html file
		location = base.substring(0, base.lastIndexOf("/")) + "/" + location;
		result = new URL(location);
	    }
            catch (MalformedURLException ee)
            {
                // should never happen, since base is valid
            }
	}

	finally
	{
            try
            {
		// fake out Java security by getting data echoed to us
		return new URL(ECHOER + location);
	    }
            catch (MalformedURLException ee)
            {
                // should never happen, since echoer is valid
            }
        }

        // appease Java compiler
        return result;
    }
}

