/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*-------------------------------------------------------------------------------
File:                           JawaaTreeNode.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:

--------------------------------------------------------------------------------*/
package jawaa.structure;

import java.awt.*;
import jawaa.util.*;
import jawaa.extras.arrow.*;
import java.util.Vector;
import jawaa.object.JawaaText;

public class JawaaTreeNode extends JawaaGraphNode
{
    public JawaaTreeNode(String name, Color foreground, Color
			 background, String[] s, int x, int y, int
			 width, int height)
    {
	super(name, foreground, background, s, x, y, width, height);
	myPointers = new Vector(1);
	myArrows = new Vector(2);
	myArrows.addElement(null);
	myArrows.addElement(null);
    }

    public JawaaTreeNode(JawaaNode node)
    {
	super(node.getName(), node.getColor(), node.getBackground(),
	      node.getAllText(), node.getLocation(), node.getSize()[0],
	      node.getSize()[1], node.getOutline());
	myPointers = new Vector(1);
	myArrows = new Vector(2);
	myArrows.addElement(null);
	myArrows.addElement(null);
    }

    public SmartArrow addChild(JawaaGraphNode n, Color c)
    {
	if(myArrows.elementAt(0) == null)
	    return addLeftChild(n, c);
	else return addRightChild(n, c);
    }

    public SmartArrow addLeftChild(JawaaGraphNode n, Color c)
    {
	SmartArrow temp = new SmartArrow(this, n, c);
	n.addPointer(temp);
	myArrows.setElementAt(temp, 0);
	return temp;
    }

    public SmartArrow addRightChild(JawaaGraphNode n, Color c)
    {
	SmartArrow temp = new SmartArrow(this, n, c);
	n.addPointer(temp);
	myArrows.setElementAt(temp, 1);
	return temp;
    }

    public void addPointer(SmartArrow arrow)
    {
	myPointers.addElement(arrow);
    }

    public JawaaTreeNode getLeftChild()
    {
	if(myArrows.elementAt(0) != null)
	    return (JawaaTreeNode)((SmartArrow)myArrows.elementAt(0)).getNext();
	else return null;
    }

    public JawaaTreeNode getRightChild()
    {
	if(myArrows.elementAt(1) != null)
	    return (JawaaTreeNode)((SmartArrow)myArrows.elementAt(1)).getNext();
	else return null;
    }


    public ListNode leftContour;
    public ListNode rightContour;
    public int offset = 0;
}
