/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
                                
-------------------------------------------------------------------------------*/
package jawaa.structure;


import java.awt.*;
import java.util.Vector;
import jawaa.anim.AnimController;
import jawaa.util.*;
import jawaa.object.*;
import java.io.*;

public abstract class JawaaNodeCollection extends JawaaContainer
{
    public JawaaNodeCollection(String[] args)
    {
	super(args);
    }

    public void build(String[] args)
	throws ArrayIndexOutOfBoundsException, NumberFormatException,
	       NullPointerException
    {
	FontMetrics metric = AnimController.getFontMetrics();
	String[][] temp;
	
	//get location of first cell
	myLocation = new Point(Integer.parseInt(args[2]),
			       Integer.parseInt(args[3]));

	//get number of cells and number of data per cell
	setBounds(args[4]);

	temp = new String[myLength][myItemCount];

	int i = 5;
	
	int longest = 0; //widest string length
	for(int k=0; k < myLength; k++)
	{
	    for(int j=0; j<myItemCount; j++)
	    {
		if(metric.stringWidth(args[i]) > longest)
		    longest = metric.stringWidth(args[i]);
		temp[k][j] = args[i];
		i++;
	    }
	}

	//determine orientation
	if(args[i].equals("HORZ") || args[i].equals("horz"))
	    myOrientation = HORIZONTAL;
	else if(args[i].equals("VERT") || args[i].equals("vert"))
	    myOrientation = VERTICAL;
	else {
	    //notify error handler
	    ErrorHandler.error(this, "no orientation specification found(HORZ or VERT)");
	}

	i++;
       	myColor = ColorFactory.getColor(args[i]);
	i++;
	myBackground = ColorFactory.getColor(args[i]);
	i++;
	myTextColor = ColorFactory.getColor(args[i]);
	myCellWidth = longest + 25;
	myCellHeight = (metric.getMaxAscent() +
			metric.getMaxDescent() + 2)*myItemCount;

	assembleData(temp);
    }

    protected void setBounds(String s) throws
    StringIndexOutOfBoundsException, NumberFormatException
    {
	int point = s.indexOf(".");
	if(point == -1)
	{
	    myLength = Integer.parseInt(s);
	    myItemCount = 1;
	}
	else
	{
	    myLength = Integer.parseInt(s.substring(0,point));
	    
	    myItemCount = Integer.parseInt(s.substring(point+1,
						       s.length()));
	}
	

    }
   
    public void paint(Graphics g)
    {
	initText();
	while (hasText())
	{
	    ((JawaaObject)nextText()).paint(g);
	}
	super.paint(g);
    }

    public void offsetLocation(int x, int y)
    {
	myLocation.x += x;
	myLocation.y += y;
	initText();
	while(hasText())
	{
	    ((JawaaObject)nextText()).offsetLocation(x,y);
	}
	super.offsetLocation(x, y);
    }


    public void off()
    {
	initText();
	while(hasText())
	{
	    ((JawaaText)nextText()).setColor("transparent");
	}
    }
    
    public void on()
    {
	initText();
	while(hasText())
	{
	    ((JawaaText)nextText()).setColor("black");
	}
    }

    public void setTextColor(String color)
    {
	setTextColor(ColorFactory.getColor(color));
    }

    public void setTextColor(Color c)
    {
	super.setTextColor(c);
	init();
	while(hasNext())
	{
	    try{
		((JawaaShape)next()).setTextColor(c);
	    }
	    catch(ClassCastException e){
		
	    }
	}
    }  
    
    public Color getTextColor()
    {
	return myTextColor;
    }

    protected abstract void assembleData(String[][] data);
    protected abstract JawaaNode makeCell(int index, String[] data);
    protected abstract JawaaText makeIndex(int index);
    public abstract Object next();
    public abstract boolean hasNext();
    public abstract boolean hasText();
    public abstract Object nextText();
    public abstract void init();
    public abstract void initText();
    
  
    protected int myLength = 0;
    protected int myItemCount = 0;
 
    protected int myCellWidth = 0;     //pixel width
    protected int myCellHeight = 0;    //pixel height

    protected  int myOrientation = 0;  //either vertical or horizontal
    protected final int VERTICAL = 1;
    protected final int HORIZONTAL = 0;
}
