/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*-------------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------------*/
package jawaa.structure;

import jawaa.object.*;
import java.awt.*;
import jawaa.util.*;

public abstract class JawaaContainer extends JawaaShape
{
    public JawaaContainer()
    {
    }

    public JawaaContainer(String[] args)
    {
	super(args);
    }

    
    /**
     * Should be overriden by subclasses
     */
    public JawaaObject get(int i)
    {
	return null;
    }

    public JawaaObject get(int i, int j)
    {
	return null;
    }
    
    /**********************\
     * Iterator functions *
    \**********************/
    public abstract void init();
    public abstract boolean hasNext();
    public abstract Object next();
   
    public void paint(Graphics g)
    {
	init();
	while(hasNext())
	{
	    ((JawaaObject)next()).paint(g);
	    
	}
    }

    public void offsetLocation(int x, int y)
    {
	myLocation.x += x;
	myLocation.y += y;
	init();
	while(hasNext())
	{
	    ((JawaaObject)next()).offsetLocation(x,y);
	}
    }

    public void setColor(String color)
    {
	super.setColor(color);
	init();
	while(hasNext())
	{
	    ((JawaaObject)next()).setColor(color);
	}
    }
    
    public void setColor(Color color)
    {
	super.setColor(color);
	init();
	while(hasNext())
	{
	    ((JawaaObject)next()).setColor(color);
	}
    }

    public void setBackground(String color)
    {
	setBackground(ColorFactory.getColor(color));
    }

    public void setBackground(Color c)
    {
	super.setBackground(c);
	init();
	while(hasNext())
	{
	   try{
		((JawaaShape)next()).setBackground(c);
	    }
	    catch(ClassCastException e){
		
	    }
	}
    }
    
      public void setTextColor(String color)
    {
	super.setTextColor(color);
	init();
	while(hasNext())
	{
	    ((JawaaShape)next()).setTextColor(color);
	}

    }

    public void setTextColor(Color c)
    {
	super.setTextColor(c);
	init();
	while(hasNext())
	{
	   try{
	       ((JawaaObject)next()).setTextColor(c);
	    }
	    catch(ClassCastException e){
		
	    }
	}
    }
    
}
