/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------*/
package jawaa.command;

import java.awt.*;
import jawaa.structure.*;
import jawaa.util.*;
import jawaa.extras.arrow.*;
import jawaa.anim.AnimController;
import jawaa.object.*;
import jawaa.app.*;


public class JawaaNodes extends JawaaCommand
{
    public JawaaNodes (String[] args)
    {
	super("JawaaNodes");
	try 
	{
	    myName = args[1];
	    myLocation = new Point(Integer.parseInt(args[2]),
				   Integer.parseInt(args[3]));
	    myWidth = Integer.parseInt(args[4]);
	    myHeight = Integer.parseInt(args[5]);
	    myItemCount = Integer.parseInt(args[6]);
	    temp = new String[myItemCount];
	    int i = 7;
	    int longest = 0;
	    FontMetrics metric = AnimController.getFontMetrics();
	    for(int j = 0; j < myItemCount; j++)
	    {
	       	
		if (metric.stringWidth(args[i]) > longest)
		    longest = metric.stringWidth(args[i]);
		temp[j] = args[i];
		i++;
	    }
	    myColor = ColorFactory.getColor(args[i++]);
	    myBackground = ColorFactory.getColor(args[i++]);
	    myTextColor = ColorFactory.getColor(args[i++]);

	    if (args[i].equals("CIRCLE"))	myShape="circle";
	    else if (args[i].equals("RECT"))	myShape="rect";
	    else 		                myShape="rect";
	   
	    
	    //  setTextLocations();
	}
	catch(Exception e)
	    {
		ErrorHandler.error(this, "syntax error", e, false);
	    }
	
    }

    protected Point getCenter ()
    {
	return new Point(myLocation.x + myWidth / 2,
			 myLocation.y + myHeight / 2);
    }

    protected void makeText(FontMetrics metric, String[] s, Point start)
    {
	myText = new JawaaText[s.length];
	for (int i = 0; i < s.length; i++)
	{
	    Point offset = new Point(0,0);
	    myText[i] = new JawaaText(s[i], offset, myTextColor);
	}
    }

    protected Point calcVertOffset (FontMetrics metric, String[] s, Point point)
    {
	int offset = getCenter().y - point.y;
	if (s.length % 2 != 0)
	{
	    offset -= metric.getMaxAscent();
	}

	int index = s.length / 2;
	for (int i = 0; i < index; i++)
	{
	    offset -= (metric.getMaxAscent() + metric.getMaxDescent() + 2);
	}

	if (offset < 0)    return point;
	else               return new Point(point.x, point.y + offset);
    }

     protected int calcHorzOffset (JawaaText t, int width)
    {
	int offset = 0;
	offset = (width - t.stringWidth())/2;
	if(offset < 0)
	    return 0;
	else return offset;
    }


     private void setTextLocations ()
    {
	getBoundingBox(myText);
	Point cen = getCenter();
	Point p =  new Point(cen.x-width/2, cen.y-height/2);

	int height2  = 0;
	for(int i = 0; i<myText.length; i++)
	{
	    if(i!=0)
	    {
		height2 += myText[i].getMaxAscent() + 2 + myText[i-1].getMaxDescent();
	    }
	    else
	    {
		height2 += myText[i].getMaxAscent() + 2;
	    }
	    myText[i].setLocation(p.x+calcHorzOffset(myText[i], width),p.y+height2);
	}
    }

     public void getBoundingBox (JawaaText[] s)
    {
	width = 0;
	height = 0;

	for(int i = 0; i < s.length; i++)
	{
	    height += s[i].getHeight() + 2;
	    if (s[i].stringWidth() > width)
	    {
		width = s[i].stringWidth();
	    }
	}
    }

  public boolean step()
    {
	if (AnimController.isRunning())
        {
	    try
	    {
		FontMetrics metric = AnimController.getFontMetrics();
	
		if (myShape == "circle")
		{
		    myOutline = new JawaaCircle(myLocation.x, 
						myLocation.y,
						myWidth, myColor, myBackground);
		    makeText(metric, temp, calcVertOffset(metric, temp, myLocation));
		}
		else 
		{
		    myOutline = new JawaaRectangle(myLocation.x, 
						   myLocation.y,
						   myWidth, myHeight,
						   myColor,myBackground);
		    makeText(metric, temp, calcVertOffset(metric, temp, myLocation));
		}

	
			setTextLocations();
	
		JawaaGraphNode begin = new JawaaGraphNode(myName, myColor, myBackground,
							  myTextColor, myText, myLocation,
							  myWidth, myHeight, myOutline);
		myData.put(myName, begin);
	       	return false;
	    }
	    catch(ClassCastException e)
	    {
		ErrorHandler.error(this, "not a valid GraphNode", false);
	    }
	}
	return false;
    }
	
    private String myName;
    private Point myLocation;
    private int myWidth, myHeight, myItemCount;
    private Color myColor;
    private Color myBackground;
    private Color myTextColor;
    private String myShape;
    private JawaaShape myOutline;
    private JawaaText[] myText;
    private String[] temp;
    public int width, height;

   

}
