/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------*/
package jawaa.command;

import jawaa.structure.*;
import jawaa.util.*;
import jawaa.extras.arrow.*;
import jawaa.anim.AnimController;

public class ConnectNodesCommand extends JawaaCommand
{
    public ConnectNodesCommand(String[] args)
    {
	super("ConnectNodes");
	try
	{
	    myName = args[1];
	    myTarget = args[2];
	    myTarget2 = args[3];
	    myColor = args[4];
	    myNum = Integer.parseInt(args[5]);
	}
	catch(Exception e)
	{
	    ErrorHandler.error(this, "syntax error", e, false);
	}
    }

    public boolean step ()
    {
	if (AnimController.isRunning())
	{
	    try{
		JawaaGraphNode begin = (JawaaGraphNode)myData.get(myTarget);
		JawaaGraphNode end = (JawaaGraphNode)myData.get(myTarget2);
		SmartArrow temp = begin.addChild(end,
						 ColorFactory.getColor(myColor), myNum);
		temp.setName(myName);
		myData.put(myName, temp);
		return false;
	    }
	    catch(ClassCastException e)
	    {
		ErrorHandler.error(this, "not a valid GraphNode", false);
	    }
	}
	return false;
    }


    private String myBool;
    private String myTarget2;
    private String myName;
    private String myColor;
    private int myNum;
}
