/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------*/
package jawaa.app;

import java.io.*;
import java.util.*;
import java.net.URL;
import java.awt.event.*;
import jawaa.util.*;
import jawaa.object.JawaaObject;
import jawaa.command.JawaaCommand;
import jawaa.anim.AnimController;


public class JawaaModel extends Observable implements JawaaListener
{
    public JawaaModel (JawaaGui gui)
    {
	myGui = gui;
	myObjects = new JawaaHash();
    }

    public void start (URL script)
    {
	try
	{
	    System.out.println(script);
	    myObjects.reset();
	    myScript = new BufferedReader(new InputStreamReader((InputStream)script.getContent()));
	    myInterpreter = new Interpreter(myScript);
	    step();
	}
	catch (IOException e)
	{
	    ErrorHandler.error(this, "unable to read script " + 
			       script.toString().substring(script.toString().indexOf("=")));
	}
    }
    
    public void step ()
    {
	if (myInterpreter.hasNext())
	    {
		Object obj = myInterpreter.next();
		if (obj != null)
		    {
			if (obj instanceof JawaaObject)
			    {
				processObject((JawaaObject)obj);
			    }
			else if (obj instanceof JawaaCommand)
			    {
				processCommand((JawaaCommand)obj);
			    }
			else
			    {
				System.out.println("Invalid type");
			    }
		    }
	    }
	else
	    {
		System.out.println("DONE");
		AnimController.stop();
		actionCompleted();
	    }
    }

    public void stop ()
    {
	if (myScript != null)
	{
	    try
	    {
		myScript.close();
	    }
	    catch (IOException e)
	    {
	    }
	}
    }


    private void processObject (JawaaObject obj)
    {
	    myObjects.put(obj.getName(), obj);
	    actionCompleted();
    }

    private void processCommand (JawaaCommand obj)
    {
	try
	{
	    obj.addListener(this);
	    obj.setData();
	    new Thread(obj).start();
        
	}
	catch (NullPointerException e)
	{
	    ErrorHandler.error(myInterpreter, "no such object " + obj.getTarget(), true);
	}
    }

    public void actionPerformed ()
    {
	postChange();

    }

    public void actionCompleted ()
    {
	postChange();
	myGui.actionCompleted();

	if (AnimController.isRunning())
	{
	    step();
	}
    }

    private void postChange ()
    {
	setChanged();
	notifyObservers(myObjects);
    }

    private void sleep ()
    {
	try
	{
	    Thread.sleep(myDelay);
	}
	catch (InterruptedException e)
	{
	}
    }

    private JawaaGui myGui;
    private JawaaHash myObjects;
    private BufferedReader myScript;
    private Interpreter myInterpreter;
    private int myDelay = 50;
}
