/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:

--------------------------------------------------------------------------*/
package jawaa.app;

import java.awt.*;
import java.net.*;
import java.util.*;
import java.applet.*;
import java.awt.event.*;
import java.util.Observer;
import java.util.Observable;
import jawaa.anim.*;
import jawaa.util.*;


public class JawaaGui extends Applet
{
     /**
     * Set up model and user interface.
     */
    public void init ()
    {
	myCanvas = new AnimationCanvas(getSize());
	myController = new AnimController(myCanvas);
	myModel = new JawaaModel(this);
	myModel.addObserver(myCanvas);

	setLayout(new BorderLayout());
	add("Center", myCanvas);
	add("South", new UserPanel());
    }

    public void start ()
    {
    }

    public void begin ()
    {
	myController.start();
	// automatically reload script on start
	myModel.start(getAnimScript());
    }

    public void stop ()
    {
	myController.stop();
	myModel.stop();
	ErrorHandler.getInstance().reset();
    }

    public void pause ()
    {
	myController.pause();
    }

    public void resume ()
    {
	myController.start();
	myModel.step();
    }

    public void actionCompleted ()
    {
	if (! stepb.isEnabled())
	{
	    stepb.setEnabled(true);
	}
    }


    private URL getAnimScript ()
    {
    
        ResourceBundle rb = ResourceBundle.getBundle("jawaa.app.resources.Applet");

        String base = getDocumentBase().toString();
        String location = getParameter(rb.getString("APPLET_PARAM"));
	URL result = null;

        // if none, assume it is named same as html file, but .anim extension
        if (location == null)
        {
            location = base.substring(0, base.lastIndexOf(".")) + rb.getString("SCRIPT_EXT");
        }

        try
        {
            result = new URL(location);
        }
        catch (MalformedURLException e)
        {
            try
            {
		// if not fully specified URL, assume in same location as html file
		location = base.substring(0, base.lastIndexOf("/")) + "/" + location;
		result = new URL(location);
	    }
            catch (MalformedURLException ee)
            {
                // should never happen, since base is valid
            }
	}

	finally
	{
            try
            {
		// fake out Java security by getting data echoed to us
		return new URL(rb.getString("APPLET_ECHOER") + location);
	    }
            catch (MalformedURLException ee)
            {
                // should never happen, since echoer is valid
            }
        }

        // appease Java compiler
        return result;
    }


    private AnimController myController;
    private AnimationCanvas myCanvas;
    private JawaaModel myModel;
    private Scrollbar sb;


    class UserPanel extends Panel
    {
	public UserPanel()
	{
	    setLayout(new BorderLayout());
	    Panel panel = new Panel(new GridLayout(1, 4));
	    ButtonListener listen = new ButtonListener();

	    startb = new Button("Start");
	    startb.addActionListener(listen);
	    startb.setBackground(Color.lightGray);
	    panel.add(startb);

	    stopb = new Button("Stop");
	    stopb.setBackground(Color.lightGray);
	    panel.add(stopb);
	    stopb.addActionListener(listen);

	    pauseb = new Button("Pause");
	    pauseb.setBackground(Color.lightGray);
	    pauseb.addActionListener(listen);
	    panel.add(pauseb);

	    stepb = new Button("Step");
	    stepb.setVisible(false);
	    stepb.addActionListener(listen);
	    stepb.setBackground(Color.lightGray);
	    panel.add(stepb);

	    sb = new Scrollbar(Scrollbar.HORIZONTAL, 50, 1, 0, 100);
	    sb.addAdjustmentListener(new AnimSpeedListener());
	    add("South", sb);
	    add("Center", panel);
	}
    }


    Button startb;
    Button stopb;
    Button stepb;
    Button pauseb;

    class AnimSpeedListener implements AdjustmentListener
    {
	public void adjustmentValueChanged(AdjustmentEvent ev)
	{
	    myController.setSpeed(ev.getValue());
	}
    }

    class ButtonListener implements ActionListener
    {
	public void actionPerformed(java.awt.event.ActionEvent ev)
	{
	    String com = ev.getActionCommand();
	    if (com.equals("Start"))
	    {
		((Button)ev.getSource()).setEnabled(false);
		begin();
	    }
	    else if (com.equals("Stop"))
	    {
		stop();
		stepb.setVisible(false);
		startb.setEnabled(true);
		pauseb.setLabel("Pause");
	    }
	    else if (com.equals("Pause"))
	    {
		if (myController.isRunning())
		{
		    pause();
		    ((Button)ev.getSource()).setLabel("Unpause");
		    stepb.setVisible(true);
		}
	    }
	    else if (com.equals("Unpause"))
	    {
		resume();
		((Button)ev.getSource()).setLabel("Pause");
		stepb.setVisible(false);
	    }
	    else if (com.equals("Step"))
	    {
		((Button)ev.getSource()).setEnabled(false);
		myModel.step();
	    }
	}
    }
}
