/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------*/
package jawaa.anim;

import java.awt.*;
import java.util.Observer;
import java.util.Observable;
import jawaa.util.JawaaHash;
import jawaa.anim.*;


public class AnimationCanvas extends Canvas implements Observer
{
    public AnimationCanvas (Dimension size)
    {
	setSize(size);
	setBackground(Color.white);
    }


    // override component update so it does not clear screen before painting
    public void update (Graphics g)
    {
	paint(g);
    }

    // paint image of jawwa objects onto graphics
    public void paint (Graphics g)
    {
	if (myImage != null)
	{
	    g.drawImage(myImage, 0, 0, this);
	}
    }

    // when notified of change, draw changed objects into image and signal 
    // we are ready to paint
    public void update (Observable ob, Object o)
    {
	if (! AnimController.isStopped())
	{
	    if ((myImage == null) ||
		(getSize().width != myImage.getWidth(this)) || 
		(getSize().height != myImage.getHeight(this)))
	    {
		myImage = createImage(getSize().width, getSize().height);
	    }
	 
	    myImage.getGraphics().clearRect(0, 0, getSize().width, getSize().height);
	    ((JawaaHash)o).touchAll(myImage.getGraphics());
	    repaint();
	}
    }

    public FontMetrics getFontMetrics ()
    {
        if (myImage != null)
	{
	    return myImage.getGraphics().getFontMetrics();
	}
	else
	{
	    return Toolkit.getDefaultToolkit().getFontMetrics(new Font("Dialog", Font.PLAIN, 12));
	}
    }

    private Image myImage;
}
