/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------*/
package jawaa.anim;


public class AnimProgression
{
    public AnimProgression (int[] begin, int[] offsets)
    {
	this(begin, offsets, AnimController.getSpeed());
    }

    public AnimProgression (int[] begin, int[] offsets, int def)
    {
	DEFAULT_LOOPS = def;
	init(begin, offsets);
    }

    private void init (int[] begin, int[] offsets)
    {
	int largest = 0;
	myInitial = new double[begin.length];
	myTarget = new DataPoint[begin.length];
	for (int i = 0; i <offsets.length; i++)
	{
	    myTarget[i] = new DataPoint(offsets[i]);
	    if (offsets[i] > largest)
		largest = offsets[i];
	    myInitial[i] = (double)begin[i];
	}
	toReturn = new int[offsets.length];

	setDelta(largest);
    }

    protected void setDelta (int largest)
    {
	for (int i = 0; i < myTarget.length; i++)
	{
	    ((DataPoint)myTarget[i]).setDelta(DEFAULT_LOOPS);
	}
    }


    public int[] step ()
    {
	for (int i = 0; i < myTarget.length; i++)
	{
	    myInitial[i] += ((DataPoint)myTarget[i]).step();
	    toReturn[i] = (int)Math.rint(myInitial[i]);
	}
	complete = checkComplete();

	return toReturn;
    }

    private boolean checkComplete ()
    {
	for (int i = 0; i < myTarget.length; i++)
	{
	    if (!((DataPoint)myTarget[i]).done) return false;
	}

	return true;
    }

    private double[] myInitial;
    private DataPoint[] myTarget;
    private int[] toReturn;
    public boolean complete = false;
    private int DEFAULT_LOOPS = 16;

    class DataPoint
    {
	public DataPoint(int number)
	{
	    myNum = number;
	    myAbs = Math.abs(number);
	    myNeg = (myAbs == 0) ? 1 : myNum / myAbs;
	}

	public void setDelta (double num)
	{
	    myDelta = (double)myAbs / num;
	}

	public double step ()
	{
	    double temp = myProgress + myDelta;
	    if ((int)Math.rint(temp) > myAbs)
	    {
		myProgress = myAbs;
		return myAbs - myProgress;
	    }

	    myProgress += myDelta;
	    if((int)Math.rint(myProgress) >= myAbs)
	    {
		done = true;
	    }

	    return (myNeg * myDelta);
	}

       
	public boolean done = false;
	public int myNum;
	public int myAbs;
	public int myNeg; // +/- 1
	public double myDelta;
	private double myProgress = 0.0;
    }
}
