/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------
File:                           StringParser.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
This utility allows for the tokenization and parsing of Java string
objects.  Many of the attributes of the parser can be defined.
-------------------------------------------------------------------------------*/
package jawaa.util;

import java.util.Vector;


/**
 * A simple StringParser that has the same functions as the
 * StringTokenizer. This parser defines a token in a different manner
 * than the StringTokenizer.
 *
 * A token is still considered to be a span of characters
 * separated by a defined set of delimiters.  However, a
 * new addition to this definition is that consecutive characters
 * enclosed in brackets ([]) or quotes ("") are considered a single
 * token.  For example the string "abc def [ghi jkl] mno" would be
 * broken up into only 4 tokens, "abc", "def", "[ghi jkl]", and "mno".
 * The default delimiters are the carriage return, space, and tab
 * characters. Additional delimiters can be specified.
 *
 * @author Pretesh patel
 */
public class StringParser
{
    public StringParser (String s)
    {
	construct(s);
    }

    public StringParser (String s, boolean b)
    {
	myIncDelim = b;
	construct(s);
    }

    public StringParser (String s, String t, boolean b)
    {
	myIncDelim = b;
	construct(s, t);
    }

    public StringParser (String s, String t)
    {
	construct(s, t);
    }

    private void construct(String s)
    {
	myString = s.toCharArray();
	myCount = parseTokens();
	init();
    }

    private void construct(String s, String t)
    {
	myString = s.toCharArray();
	char[] temp = new char[EXCLUSIVE_DELIMS.length + t.length()];

	for (int i = 0; i < EXCLUSIVE_DELIMS.length; i++)
	{
	    temp[i] = EXCLUSIVE_DELIMS[i];
	}
	for(int i = 0; i < t.length(); i++)
	{
	    temp[i + EXCLUSIVE_DELIMS.length] = t.charAt(i);
	}

	EXCLUSIVE_DELIMS = temp;
	myCount = parseTokens();
	init();
    }
    
    private int parseTokens ()
    {
	myIndex = 0;
	while (myIndex < myString.length)
	{
	    if (!exclDelim(myString[myIndex]))
	    {
		if(myString[myIndex] == '"')
		    readBlock('"',false);
		else if(myString[myIndex] == '[')
		    readBlock(']',myIncDelim);
		else if(myString[myIndex] == '(')
		    readBlock(')', myIncDelim);
		else readWord();
	    }
	    myIndex++;
	}

	return mySmartStrings.size();
    }

    private void readWord ()
    {
	int length = 0;
	int index = myIndex;
	while((myIndex < myString.length) && !exclDelim(myString[myIndex]))
	{
	    length++;
	    myIndex++;
	}

	mySmartStrings.addElement(new SmartString(index, length));
    }

    private void readQuote ()
    {
	int length = 0;
	int index = myIndex;

	myIndex++;
	while((myIndex < myString.length) && (myString[myIndex] != '"'))
	{
	    length++;
	    myIndex++;
	}
	index++;
	mySmartStrings.addElement(new SmartString(index, length));
    }

    private void readBlock (char c, boolean b)
    {
	int length = 0;
	int index = myIndex;
	if (!b)
	    index++;
	myIndex++;
	while((myIndex < myString.length) && (myString[myIndex] != c))
	{
	    length++;
	    myIndex++;
	}
	if(b)
	{
	    length+=2;
	}
	mySmartStrings.addElement(new SmartString(index, length));
    }
    
    private void readBracket()
    {
	int length = 0;
	int index = myIndex;
	if(!myIncDelim)
	    index++;
	myIndex++;
	while((myIndex < myString.length) && (myString[myIndex] != ']'))
	{
	    length++;
	    myIndex++;
	}
	if(myIncDelim)
	    length+=2;
	mySmartStrings.addElement(new SmartString(index, length));
    }

    
    private boolean inclDelim(char c)
    {
	if((c == '"') || (c =='[') || (c == ']') || (c==')') || (c=='('))
	    return true;
	return false;
    }

    private boolean exclDelim(char c)
    {
	for(int i = 0; i < EXCLUSIVE_DELIMS.length; i++)
	{
	    if(c == EXCLUSIVE_DELIMS[i])
		return true;
	}
	return false;
    }


    public void init()
    {
	myIndex = 0;
    }

    public boolean hasMoreTokens()
    {
	return (myIndex < mySmartStrings.size());
    }

    public String nextToken()
    {
	return (mySmartStrings.elementAt(myIndex++)).toString();
    }

    public int countTokens()
    {
	return myCount;
    }

    /**
     * @pre array must be of length myCount
     * @post array is filled with all the tokens from this string
     */
    public void fillArray(String[] array)
    {
	init();
	int i = 0;
	while (hasMoreTokens())
	{
	    array[i] = nextToken();
	    i++;
	}
    }

    private int myCount;
    private char[] myString;
    private int myIndex = 0;
    private Vector mySmartStrings = new Vector();
    private boolean myIncDelim = true;
    private char[] EXCLUSIVE_DELIMS= {'\t', '\n', '\r', ' '};


    class SmartString
    {
	public SmartString (int i, int j)
	{
	    myIndex = i;
	    myLength = j;
	}

	public String toString ()
	{
	    return new String(myString, myIndex, myLength);
	}

	private int myIndex;
	private int myLength;
    }
}
