/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*------------------------------------------------------------------------------
File:                           NameSpace.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
A storage of the unique names created in the running of a Jawaa anim
file. Multiple uses of a single name will not be allowed.
-------------------------------------------------------------------------------*/
package jawaa.util;

import java.util.*;


/**
 * This class serves as a container to store the names of objects as
 * they are created in a jawaa program.  The namespace keeps track of
 * names and does not allow for duplicate names.  This registry of
 * names will exist as a static instance.
 *
 * @author Pretesh Patel
 */
public class NameSpace implements Iterator
{
    protected NameSpace ()
    {}


    public void addName (String s)
    {
	if (!contains(s))
	{
	    myNames.addElement(s);
	}
	else
	{
	    ErrorHandler.error(this, s + " is in use", false);
	}
    }

    public void removeName(String s)
    {
	if (contains(s))
	{
	    myNames.removeElement(s);
	}
    }

    public void reset ()
    {
	myNames.removeAllElements();
    }

    public boolean contains (String s)
    {
	for (int i = 0; i < myNames.size(); i++)
	{
	    if (s.equals((String)myNames.elementAt(i)))
	    {
		return true;
	    }
	}
	return false;
    }

    public void init ()
    {
	enum = myNames.elements();
    }

    public boolean hasNext ()
    {
	return enum.hasMoreElements();
    }

    public Object next ()
    {
        return enum.nextElement();
    }


    public void changeOrder (String target, String location)
    {}


    public void changeOrder (String target, int i)
    {}


    public String toString ()
    {
	return "NameSpace";
    }


    private Enumeration enum;
    private static Vector myNames = new Vector();
}
