/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*-------------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:        
                                
---------------------------------------------------------------------------------*/
package jawaa.structure;

import java.awt.*;
import java.util.Vector;
import jawaa.anim.AnimController;
import jawaa.util.*;
import jawaa.object.*;

public class JawaaArray extends JawaaNodeCollection
{
    public JawaaArray(String[] args)
    {
	super(args);
    }

    protected void assembleData(String[][] data)
    {
	myArray = new JawaaNode[myLength];
	myTexts = new JawaaText[myLength];
	for(int j = 0 ; j<data.length; j++)
	{
	    myArray[j] = makeCell(j, data[j]);
	    myTexts[j] = makeIndex(j);
	}
    }
    
    protected JawaaNode makeCell(int index, String[] data)
    {
	if(myOrientation == HORIZONTAL)
	{
	    return new JawaaNode(myName+index, myColor, myBackground, myTextColor,data, 
				 myLocation.x+index*myCellWidth,
				 myLocation.y, myCellWidth,
				 myCellHeight);
	}
	else
	{
	    return new JawaaNode(myName+index, myColor,
				 myBackground, myTextColor,
				 data,
				 myLocation.x,
				 myLocation.y+index*myCellHeight,
				 myCellWidth, myCellHeight);
	}
    }
    
    protected JawaaText makeIndex(int index)
    {
	Integer i = new Integer(index);
	String s = i.toString();
	Color x = ColorFactory.getColor("transparent");
	if(myOrientation == HORIZONTAL)
	{
	    Point p = new Point(myLocation.x+index*myCellWidth + myCellWidth/2, myLocation.y - 10);
	    return new JawaaText(s, p, x);
	}
	else
	{
	    Point p2 = new Point(myLocation.x - 15, myLocation.y+index*myCellHeight + 5 + myCellHeight/2); 
	    return new JawaaText(s, p2, x);
	}
    }

    public void init()
    {
	myIndex = 0;
    }

    public boolean hasNext()
    {
	return (myIndex<myArray.length);
    }
    
    public boolean hasText()
    {
	return (txt<myArray.length);
    }
    
    public Object next()
    {
	return myArray[myIndex++];
    }

     public Object nextText()
    {
	return myTexts[txt++];
    }

    public void initText()
    {
	txt = 0;
    }
    
    public JawaaObject get(int i)
    {
	return (JawaaObject)myArray[i];    
    }

    public JawaaObject get(int i, int j)
    {
	return myArray[i].get(j);
    }
    
   

    protected JawaaNode[] myArray;
    protected JawaaText[] myTexts;
    protected int myIndex = 0;
    protected int txt = 0;
}
