/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:        
                               
--------------------------------------------------------------------------*/
package jawaa.command;

import jawaa.object.*;
import jawaa.util.*;
import jawaa.anim.AnimProgression;

public class ScaleCommand extends JawaaCommand
{
    public ScaleCommand(String[] args)
    {
	super("Scale");
	try
	{
	    myTarget = args[1];
	    myPercent = Integer.parseInt(args[2]);
	}
	catch (ArrayIndexOutOfBoundsException e)
	{
	    ErrorHandler.error(this, "not enought arguments", true);
	}
	catch (NumberFormatException e)
	{
	    ErrorHandler.error(this, "number expected", false);
	    myPercent = 0;
	}

	setData();
    }

    public boolean step ()
    {
	try
	{
	    if (! myProgress.complete)
	    {
		try
		{
		    Scalable obj = (Scalable)myData.get(myTarget);
		    int[] next = myProgress.step();
		    obj.setSize(next);
		}
		catch(ClassCastException e)
		{
		    ErrorHandler.error(this, "only primitive objects can be scaled");
		}
		catch (NullPointerException e)
		{
		    ErrorHandler.error(this, "target object not found");
		}
	    }
	    return !myProgress.complete;
	}
	catch (NullPointerException e)
	{
	    // progression never started, do nothing
	}

	return false;
    }

    public void setData ()
    {
	try
	{
	    Scalable obj = (Scalable)myData.get(myTarget);
	    if (obj != null)
	    {
		double scale = myPercent / 100.0;
		int[] init = obj.getSize();
		int[] offset = new int[init.length];
		for (int i = 0; i < init.length; i++)
		{
		    offset[i] = (int)(init[i]*scale)-init[i];
		}
		myProgress = new AnimProgression(init, offset);
	    }
	    else
	    {
		ErrorHandler.error(this, "object name " +myTarget+" not found");
	    }
	}
	catch (ClassCastException e)
	{
	    ErrorHandler.error(this, "this object can not be scaled");
	}
	catch (NullPointerException e)
	{
	    ErrorHandler.error(this, "object named " +myTarget +" not found");
	}
    }


    private int myPercent;
    private String myTarget;
    private AnimProgression myProgress;
}
