/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------*/
package jawaa.command;

import java.awt.Point;
import java.util.Enumeration;
import jawaa.object.JawaaObject;
import jawaa.util.*;
import jawaa.anim.*;


public class MoveRelativeCommand extends JawaaCommand
{
    public MoveRelativeCommand (String[] args)
    {
	super("MoveRelative");
	try
	{
	    myTarget = args[1];
	    myXMove = Integer.parseInt(args[2]);
	    myYMove = Integer.parseInt(args[3]);
	}
	catch (ArrayIndexOutOfBoundsException e)
	{
	    ErrorHandler.error(this, "not enough arguments", true);
	}
	catch (NumberFormatException e)
	{
	    ErrorHandler.error(this, "number expected", false);
	    myXMove = 0;
	    myYMove = 0;
	}
	catch (Exception e)
	{
	    ErrorHandler.error(this, "syntax error", e, false);
	}
    }

    public MoveRelativeCommand (String target, int x, int y)
    {
	super("MoveRelative");
	myTarget = target;
	myXMove = x;
	myYMove = y;
    }


    public void setData ()
    {
	Point temp = ((JawaaObject)myData.get(myTarget)).getLocation();
	int[] init = {temp.x, temp.y};
	int[] offset = {myXMove, myYMove};
	myProgress = new AnimProgression(init, offset);
    }

    public boolean step ()
    {
	if (! myProgress.complete)
	{
	    try
	    {
		int[] offset = myProgress.step();
		myObj = (JawaaObject)myData.get(myTarget);
		myObj.setLocation(offset[0], offset[1]);
	    }
	    catch (NullPointerException e)
	    {
		ErrorHandler.error(this, "animation error", e, true);
	    }
	}

	return (!myProgress.complete);
    }
 
    private int myXMove = 0;
    private int myYMove = 0;
    private JawaaObject myObj;
    private AnimProgression myProgress = null;
}

