/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H. Rodger, Pretesh Patel, Ayonike Akingbade, Diana Jackson
Computer Science Department
Duke University
August 2002
Supported by National Science Foundation DUE-9752583.

Copyright (c) 2002
All rights reserved.

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author.  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission.
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           nameoffile.java
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Ayonike Akingbade, Diana Jackson
Date:                           August 2002
Description of Contents:        
                                
--------------------------------------------------------------------------*/
package jawaa.command;

import java.awt.*;
import jawaa.util.*;
import jawaa.anim.*;
import jawaa.object.JawaaObject;
import jawaa.extras.marker.*;
import jawaa.extras.arrow.*;
import jawaa.structure.*;

public class MoveMarkerCommand extends JawaaCommand implements JawaaListener
{
    public MoveMarkerCommand(String[] args)
    {
	super("MoveMarker");
	try
	{
	    myTarget = args[1];
	    myDestName = args[2];
	}
	catch (ArrayIndexOutOfBoundsException e)
	{
	    ErrorHandler.error(this, "syntax error", false);
	}
    }

    public boolean step ()
    {
	if(myCount < myReps)
	{
	    Point p = myArrow.getPathLocation(myCount++, myReps);
	    p.x -= myMarker.getSize()[0]/2;
	    p.y -= myMarker.getSize()[0]/2;
	    myMarker.setLocation(p.x,p.y);
	    return true;
	}
	else if(myThread == null)
	{
	    Point p = myDestin.getMarkerHandle(0);
	    p.x -= myMarker.getSize()[0]/2;
	    p.y -= myMarker.getSize()[0]/2;
	    myThread = new Thread(new ObjectMover(myMarker, 
						  p, 
						  4, this));
	    myThread.start();
	    return myFinish;
	}
	else return myFinish;
    }


    public void setData()
    {
	myReps = AnimController.getSpeed();
	try{
	    myMarker = (JawaaMarker)myData.get(myTarget);
	    myDestin = (Markable)myData.get(myDestName);
	    myArrow =
		((JawaaGraphNode)myMarker.getMarkedNode()).getArrowToNode(myDestin);
	    if(myArrow == null)
	    {
		ErrorHandler.error(this, "no connection exists from "
				   + myMarker.getMarkedNode() + " to "
				   + (JawaaGraphNode)myDestin, false);
		myFinish = false;
		myReps = 0;
		myThread = new Thread();
	    }
	    else myMarker.getMarkedNode().removeMarkerListener(myMarker);
	}
	catch(ClassCastException e){
	    ErrorHandler.error(this, "invalid marker or node name.", false);
	}
	catch(NullPointerException e){
	    ErrorHandler.error(this, "syntax error, name not recognized.", e, false);
	}
    }

    
    public void actionPerformed()
    {
	fireActionPerformed();
    }

    public void actionCompleted()
    {
	fireActionPerformed();
	myDestin.addMarkerListener(myMarker);
	myMarker.setNode(myDestName, myDestin);
	myFinish = false;
    }

    
    private JawaaMarker myMarker;
    private Markable myDestin;
    private SmartArrow myArrow;
    private String myDestName;
    private boolean myFinish = true;
    private Thread myThread = null;
    private int myCount = 0;
    private int myReps;
}
