/*---------------------------------------------------------------------------
-- JAWAA 2.0 --

Copyright information:

Susan H Rodger, Pretesh Patel, Diana Jackson, Ayonike Akingbade
Computer Science Department
Duke University
August 2001
Supported by National Science Foundation DUE-9752583

Copyright (c) 2002
All rights reserved

Redistribution and use in source and binary forms are permitted
provided that the above copyright notice and this paragraph are
duplicated in all such forms and that any documentation,
advertising materials, and other materials related to such
distribution and use acknowledge that the software was developed
by the author  The name of the author may not be used to
endorse or promote products derived from this software without
specific prior written permission
THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE

---------------------------------------------------------------------------*/


/*---------------------------------------------------------------------------
File:                           ChangeParamCommandjava
Package:                        JAWAA Version 2.0
Author:                         Pretesh Patel, Diana Jackson, Ayonike Akingbade
Date:                           August 2002
Description of Contents:
This class implements the Jawaa changeParam command  It is used to
change the graphical attributes of many of the objects used in the
Jawaa Language
--------------------------------------------------------------------------*/
package jawaa.command;

import jawaa.object.*;
import jawaa.structure.*;
import jawaa.extras.arrow.*;
import jawaa.command.MoveRelativeCommand;
import jawaa.util.*;
import jawaa.anim.*;
import java.awt.*;
import java.util.*;
import java.util.Enumeration;


public class ChangeParamCommand extends JawaaCommand implements JawaaListener
{
    public ChangeParamCommand(String[] args)
    {
	super("ChangeParam");
	try
	{
	    myTarget = args[1];
	    myParam = args[2];
	    myNewValue = args[3];
	}
	catch (ArrayIndexOutOfBoundsException e)
	{
	    ErrorHandler.error(this, "not enough arguments", true);
	}
	catch (Exception e)
	{
	    ErrorHandler.error(this, "syntax error");
	}
    }


    public boolean step ()
    {
	if (myThread == null)
	{
	    JawaaObject obj = (JawaaObject)myData.get(myTarget);
	    if (obj != null)
	    {
		myParam = myParam.toLowerCase();
		if (myParam.equals("color"))
		{
		    return colorStep(obj);
		}
		else if(myParam.equals("text"))
		{
		    return textStep(obj);
		}
		else if (myParam.equals("bkgrd") || myParam.equals("background"))
		{
		    return bkgrdStep(obj);
		}
		else if(myParam.equals("textcolor"))
		{
		    return textColorStep(obj);
	        }
		else if(myParam.equals("width"))
		{
		    return dimStep(obj, 0);
		}
		else if(myParam.equals("height"))
		{
		    return dimStep(obj, 1);
		}
		else if(myParam.equals("target"))
		{     
		    return ListStep(myTarget, myNewValue);
		}
		else if(myParam.equals("arrowcolor"))
		{
		    return ArrowStep(myTarget);
		}
		else if(myParam.equals("direction"))
		{     
		    return DirectionStep(myTarget, myNewValue);
		}
		else if(myParam.equals("point"))
		{
		    return pointStep(obj);
		}
		else if(myParam.equals("index"))
		{
		    return indexStep(obj);
		}
		else if(myParam.equals("switch"))
		{
		    JawaaObject obj2 = (JawaaObject)myData.get(myNewValue);
		    return switchStep(obj, obj2);
		}
		else if(myParam.equals("swap"))
		{
		    JawaaObject obj2 = (JawaaObject)myData.get(myNewValue);
		    return swapStep(obj, obj2);
		}
		else if((myParam.indexOf("x") != -1) ||
			(myParam.indexOf("X") != -1))
		{
		    return locStep(obj, 0);
		}
		else if((myParam.indexOf("y") != -1) ||
			(myParam.indexOf("Y") != -1))
		{
		   return locStep(obj, 1);
		}
		else
		{
		    ErrorHandler.error(this, myParam + " is not a valid parameter to change");
		    return false;
		}
	    }
	    else
	    {
		ErrorHandler.error(this, myTarget + ": no such object");
		return false;
	    }

	}
	return colorstuff;
    }

    private boolean pointStep(JawaaObject obj)
    {
	if(obj instanceof JawaaText)
	{
	    try{
		int[] size = {Integer.parseInt(myNewValue)};
		((Scalable)obj).setSize(size);
	    }
	    catch(NumberFormatException e){
		ErrorHandler.error(this, myNewValue + " is not a valid point size");
	    }
	    
	}
	else if (obj instanceof JawaaNode)
	{
	    try {
		int[] size = {Integer.parseInt(myNewValue)};
		((JawaaNode)obj).setTextSize(size[0]);
	    }
	    catch(NumberFormatException e){
		ErrorHandler.error(this, myNewValue + " is not a valid point size");
	    }
	}
	else if (obj instanceof JawaaGroupObject)
	{
	    JawaaHash hash = JawaaHash.getInstance();
	    
	    targets=((JawaaGroupObject)obj).getTargets();
	    for (int i=0; i<targets.size(); i++)
	    {
		JawaaObject myOb = (JawaaObject)hash.get(targets.elementAt(i)); 
		if(myOb instanceof JawaaText)
		{
		    try{
			int[] size = {Integer.parseInt(myNewValue)};
			((Scalable)hash.get(targets.elementAt(i))).setSize(size);
		    }
		    catch(NumberFormatException e){
			ErrorHandler.error(this, myNewValue + " is not a valid point size");
		    }
		    
		}
		else if (myOb instanceof JawaaNode)
		{
		    try {
			int[] size = {Integer.parseInt(myNewValue)};
			((JawaaNode)hash.get(targets.elementAt(i))).setTextSize(size[0]);
		    }
		    catch(NumberFormatException e){
			ErrorHandler.error(this, myNewValue + " is not a valid point size");
		    }
		}
	    }
	}
	else
	{
	    ErrorHandler.error(this, obj.getName() + " is not a valid text object");
	}
	return false;
    }
    
    private boolean dimStep (JawaaObject obj, int j)
    {
	if(obj instanceof Scalable)
	{
	    int[] temp = new int[2];
	    if(j==0)
	    {
		temp[0] = Integer.parseInt(myNewValue);
		temp[1] = ((Scalable)obj).getSize()[1];
	    }
	    if(j==1)
	    {
		temp[0] = ((Scalable)obj).getSize()[0];
		temp[1] = Integer.parseInt(myNewValue);
	    }
	    ((Scalable)obj).setSize(temp);
	}
	else if (obj instanceof JawaaGroupObject)
	{
	    JawaaHash hash = JawaaHash.getInstance();
	    targets=((JawaaGroupObject)obj).getTargets();
	    for (int i=0; i<targets.size(); i++)
	    {
		JawaaObject myOb = (JawaaObject)hash.get(targets.elementAt(i)); 
		if (myOb instanceof Scalable)
		{
		    int[] temp = new int[2];
		    if(j==0)
			{
			    temp[0] = Integer.parseInt(myNewValue);
			    temp[1] = ((Scalable)hash.get(targets.elementAt(i))).getSize()[1];
			}
		    if(j==1)
			{
			    temp[0] = ((Scalable)hash.get(targets.elementAt(i))).getSize()[0];
			    temp[1] = Integer.parseInt(myNewValue);
			}
		    ((Scalable)hash.get(targets.elementAt(i))).setSize(temp);
		}
	    }
	}    
	else
	{
	    ErrorHandler.error(this, myTarget + " cannot be resized");
	}
	return false;
    }

    private boolean ListStep(String pointer, String pointee)
    {
	
	try 
	    {
		JawaaGraphNode begin = (JawaaGraphNode)myData.get(pointer);
		JawaaGraphNode end = (JawaaGraphNode)myData.get(pointee);
		begin.setHeight(end.getHeight());
		begin.setWidth(end.getWidth());
		String dir = begin.getDirection();
		begin.setPointerLocation(dir, end);
		Color c = begin.getArrowColor();
		SmartArrow temp = begin.addChild(end,
						 c, 1);
		
		myData.remove(pointer + "_arrow");
		temp.setName(pointer + "_arrow");
		myData.put(pointer+ "_arrow", temp);
		
	    }
	catch(ClassCastException e)
	    {
		ErrorHandler.error(this, "not a valid GraphNode", false);
	    }
	return false;
    }

    private boolean DirectionStep(String pointer, String direction)
    {
	try 
	    {
		JawaaGraphNode node = (JawaaGraphNode)myData.get(pointer);
		node.setDirection(direction);
		String dir = node.getDirection();
		node.setPointerLocation(dir, node.getConnectedNode());
		Color c = node.getArrowColor();
		SmartArrow temp = node.addChild(node.getConnectedNode(),
						 c, 1);
		
		myData.remove(pointer + "_arrow");
		temp.setName(pointer + "_arrow");
		myData.put(pointer+ "_arrow", temp);
		
	    }
	
	catch(ClassCastException e)
	    {
		ErrorHandler.error(this, "not a valid GraphNode", false);
	    }
	return false;
    }
    
    private boolean indexStep(JawaaObject obj)
    {
	try
	{
	    if(myNewValue.equals("off"))
	    {
		((JawaaNodeCollection)obj).off();
	    }
	    else
		((JawaaNodeCollection)obj).on();
	}
	catch(ClassCastException e)
	{
	    ErrorHandler.error(this, "not a valid Array", false);
	}
	return false;
    }
    
    private boolean switchStep(JawaaObject obj, JawaaObject obj2)
    {
	try 
	{
	    int n1_x = obj.getLocation().x;
	    int n1_y = obj.getLocation().y;
	    int n2_x = obj2.getLocation().x;
	    int n2_y = obj2.getLocation().y;
	    int x1 = n2_x - n1_x;
	    int y1 = n2_y - n1_y;
	    int x2 = n1_x - n2_x;
	    int y2 = n1_y - n2_y;
	    JawaaCommand com = new MoveRelativeCommand(obj.toString(), x1, y1);
	    com.addListener(this);
	    com.setData();
	    myThread = new Thread(com);
	    myThread.start();
	    myThread.sleep(1000);
	    JawaaCommand com2 = new MoveRelativeCommand(obj2.toString(),x2, y2);
	    com2.addListener(this);
	    com2.setData();
	    myThread = new Thread(com2);
	    myThread.start();
	}
	catch(ClassCastException e)
	    {
		ErrorHandler.error(this, "not a valid object", false);
	    }
	catch(Exception e)
	    {
		System.out.println("Thread sleep error: "+e);
	    }

	return false;
		
    }
    
    private boolean swapStep(JawaaObject obj, JawaaObject obj2)
    {
	if (obj instanceof JawaaNode && obj2 instanceof JawaaNode)
	{
	    for (int i = 0; i < ((JawaaNode)obj).getItemCount(); i++)
	    {
		JawaaObject o1 = ((JawaaNode)obj).get(i);
		String one = ((JawaaText)o1).getText(); 
		JawaaObject o2 = ((JawaaNode)obj2).get(i);
		String two = ((JawaaText)o2).getText();
		((JawaaNode)obj).setTexts(two, i);
		((JawaaNode)obj2).setTexts(one, i);
	    }
	    
	}
	else 
        {
	    ErrorHandler.error(this, "must be an Array cell");
	}

	return false;
    }
    private boolean locStep (JawaaObject obj, int j)
    {
	if(myParam.length() == 1)
	    {
		int x = 0,y=0;
		try{
		    
		    //x coordinate
		    if(j==0)
			{
			    x = Integer.parseInt(myNewValue) - obj.getLocation().x;
			    y = 0;
			}
		//y coordinate
		if(j==1)
		{
		    x = 0;
		    y = Integer.parseInt(myNewValue) - obj.getLocation().y;
		}
	    }
	    catch(NumberFormatException e)
	    {
		ErrorHandler.error(this, "syntax error: integer expected");
	    }
	    obj.offsetLocation(x,y);
	}
	else
	{
	    if(obj instanceof MultiPointContainer)
	    {
		multiPointLoc((MultiPointContainer)obj, j);
	    }
	}

	return false;
    }

    
    private void multiPointLoc(MultiPointContainer obj, int j)
    {
	try{
	    int x = 0, y=0;
	    String temp = myParam.substring(1);
	    int k = Integer.parseInt(temp);
	    if(j==0)
	    {
		x = Integer.parseInt(myNewValue);
		y = obj.getLocation(k).y;
	    }
	    if(j==1)
	    {
		x = obj.getLocation(k).x;
		y = Integer.parseInt(myNewValue);
	    }
	    obj.setLocation(x,y,k);
	}
	catch(NumberFormatException e)
	{
	    ErrorHandler.error(this, "syntax error: integer expected");
	}
    }

    
    private boolean textStep(JawaaObject obj)
    {
	if((obj instanceof JawaaText) || (obj instanceof JawaaNode))
	{
	    try{
		((JawaaText)obj).setText(myNewValue);
	    }
	    catch(Exception e){
		((JawaaNode)obj).setText(myNewValue);
	    }
	}
	else if (obj instanceof JawaaGroupObject)
        {
	    JawaaHash hash = JawaaHash.getInstance();
	    targets=((JawaaGroupObject)obj).getTargets();
	    for (int i=0; i<targets.size(); i++)
	    {
		JawaaObject myOb = (JawaaObject)hash.get(targets.elementAt(i));
		if ((myOb instanceof JawaaText) || (myOb instanceof JawaaNode))
		{
		    try{
			((JawaaText)hash.get(targets.elementAt(i))).setText(myNewValue);
		    }
		    catch(Exception e){
			((JawaaNode)hash.get(targets.elementAt(i))).setText(myNewValue);
		    }
		}
	    }
	}
	else
	   ErrorHandler.error(this, myTarget +" has no text on it");
	return false;
    }
    
    private boolean textColorStep(JawaaObject obj)
    {

	if((obj instanceof JawaaText)||(obj instanceof JawaaNode))
	{
	    try {
		myThread = new Thread(new ColorMorpher(((JawaaText)obj).getTextColor(),
					  ColorFactory.getColor(myNewValue),
					  obj, this, ColorMorpher.TEXTCOLOR));
		myThread.start();	    
	    } catch(Exception e) {
	      
		myThread = new Thread(new ColorMorpher(((JawaaNode)obj).getTextColor(),
					  ColorFactory.getColor(myNewValue),
					  obj, this, ColorMorpher.TEXTCOLOR));
		myThread.start();
		
	    }
	}
	
	else if (obj instanceof JawaaContainer)
	    {
		myThread = new Thread(new ColorMorpher(((JawaaContainer)obj).getTextColor(),
						       ColorFactory.getColor(myNewValue),
						       obj, this, ColorMorpher.TEXTCOLOR));
		myThread.start();
	    }

	else if(obj instanceof JawaaGroupObject)
	{
	    JawaaHash hash = JawaaHash.getInstance();
	    
	    targets=((JawaaGroupObject)obj).getTargets();
	    for (int i=0; i<targets.size(); i++)
	    {
		JawaaObject myOb = (JawaaObject)hash.get(targets.elementAt(i)); 
		
		if((myOb instanceof JawaaText) || 
		   (myOb instanceof JawaaNode))
	        {
		    try
		    {
			myThread = new Thread(new
			    ColorMorpher(((JawaaText)hash.get(targets.elementAt(i))).getTextColor(),
			      ColorFactory.getColor(myNewValue),
			      (JawaaText)hash.get(targets.elementAt(i)), this, ColorMorpher.TEXTCOLOR));
			myThread.start();
		    }
		    catch(Exception e)
		    {
			myThread = new Thread(new
			    ColorMorpher(((JawaaNode)hash.get(targets.elementAt(i))).getTextColor(),
			      ColorFactory.getColor(myNewValue),
			      (JawaaNode)hash.get(targets.elementAt(i)), this, ColorMorpher.TEXTCOLOR));
			myThread.start();
		    }
		}
		else if (myOb instanceof JawaaContainer)
		{
		    try {
		    myThread = new Thread(new 
			ColorMorpher(((JawaaContainer)hash.get(targets.elementAt(i))).getTextColor(),
				     ColorFactory.getColor(myNewValue), 
				     (JawaaContainer)hash.get(targets.elementAt(i)), 
				     this, ColorMorpher.TEXTCOLOR));
		    myThread.start();
		    }
		    catch(Exception e)
			{
			}
		}
		
	    }
	}	 
	else
	{
	    ErrorHandler.error(this, myTarget+" has no text on it");
	    return false;
	}

	return colorstuff;	   
    }	
    
    private boolean ArrowStep(String pointer)
    {
	JawaaGraphNode begin = (JawaaGraphNode)myData.get(pointer);
	if(begin instanceof JawaaGraphNode)
	    {   
		String str = pointer + "_arrow";
		JawaaObject Obj = (JawaaObject)myData.get(str);
		
		myThread = new Thread(new ColorMorpher(begin.getArrowColor(),
						       ColorFactory.getColor(myNewValue),
						       Obj, this, ColorMorpher.ARROWCOLOR));
		myThread.start();
		begin.setArrowColor(ColorFactory.getColor(myNewValue));
	    }
	else
	    {
		ErrorHandler.error(this, "not a valid arrow");
		return false;
	    }
	
	
	return colorstuff;
    }
    
    private boolean colorStep(JawaaObject obj)
    {

	
	if(obj instanceof JawaaGroupObject)
	{
	    JawaaHash hash = JawaaHash.getInstance();
	    targets=((JawaaGroupObject)obj).getTargets();
	    for (int i=0; i<targets.size(); i++)
		{
		    
       		myThread = new Thread(new
		    ColorMorpher(((JawaaObject)hash.get(targets.elementAt(i))).getColor(),
				 ColorFactory.getColor(myNewValue),
				 (JawaaObject)hash.get(targets.elementAt(i)), this, ColorMorpher.FOREGROUND));
		myThread.start();
		}
	}
	else
	{
	    myThread = new Thread(new ColorMorpher(obj.getColor(),
						   ColorFactory.getColor(myNewValue),
					  obj, this, ColorMorpher.FOREGROUND));
	    myThread.start();
	}

	return colorstuff;
    }

    private boolean bkgrdStep(JawaaObject obj)
    {
	
       
	if(obj instanceof JawaaGroupObject)
	{
	    JawaaHash hash = JawaaHash.getInstance();
	    targets=((JawaaGroupObject)obj).getTargets();
	    for (int i=0; i<targets.size(); i++)
	    {
		if((JawaaObject)hash.get(targets.elementAt(i)) instanceof JawaaNode)
		    {
			myThread = new Thread(new
			    ColorMorpher(((JawaaShape)hash.get(targets.elementAt(i))).getBackground(),
					 ColorFactory.getColor(myNewValue),
					 (JawaaShape)hash.get(targets.elementAt(i)), this, ColorMorpher.BACKGROUND));
			myThread.start();
		    }
			

		else if((JawaaObject)hash.get(targets.elementAt(i)) instanceof JawaaShape)
		{
		    myThread = new Thread(new
		    ColorMorpher(((JawaaShape)hash.get(targets.elementAt(i))).getBackground(),
			     ColorFactory.getColor(myNewValue),
			     (JawaaShape)hash.get(targets.elementAt(i)), this, ColorMorpher.BACKGROUND));
		    myThread.start();
		}
       	    }
	}
	else  if(obj instanceof JawaaShape)
	{
	    myThread = new Thread(new
		ColorMorpher(((JawaaShape)obj).getBackground(),
			     ColorFactory.getColor(myNewValue),
			     obj, this, ColorMorpher.BACKGROUND));
	    myThread.start();
	}
	else
	{
	    ErrorHandler.error(this, myTarget + " has no background");
	    return false;
	}
	return colorstuff;
	
    }
    
    public void actionPerformed()
    {
	fireActionPerformed();
    }

    public void actionCompleted()
    {
	fireActionPerformed();
	colorstuff = false;
    }

    private String myParam;
    private String myNewValue;
    private Thread myThread = null;
    private boolean colorstuff = true;
    private Vector targets;
}
