/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import generator.Generator;
import generatorImplementations.SortingAlgorithm;
import java.util.Locale;

public class ShellSort
extends SortingAlgorithm
implements Generator {
    private static final String DESCRIPTION = "Der Gedanke, der hinter ShellSort steht, kann wie folgt beschrieben werden:\n1. Die Daten werden in eine zweidimensionale Matrix geschrieben\n2. Die Spalten der Matrix werden einzeln sortiert\nDaraus resultiert eine grobe Sortierung. Dieser Schritt wird \u02c6fter  wiederholt, wobei jeweils die Breite der Matrix verringert wird,  bis die Matrix nur noch aus einer einzigen vollst\u2030ndig sortierten Spalte besteht.\n\nShellSort arbeitet instabil und in-place.";
    private static final String HEADER_TEXT = "text \"f1-01\" \"Shell Sort\" at (120,50) color black font SansSerif size 32 bold\n{\n  text \"f1-02a\" \"Das Verfahren Sortieren durch Einfuegen ist langsam, weil es Elemente\" at (20,100) color black font SansSerif size 24\n  text \"f1-02b\" \"immer nur um eine Position nach rechts verschiebt.\" at (20,130) color black font SansSerif size 24\n}\n{\n  text \"f1-03a\" \"Shellsort versucht, Elemente durch gr\u02c6\ufb02ere Spruenge schneller an die \" at (20,170) color black font SansSerif size 24\n  text \"f1-03b\" \"Zielposition zu bringen\" at (20,200) color black font SansSerif size 24\n}\n{\n  text \"f1-04a\" \"Dabei werden die Daten in jedem Schritt h-sortiert. Eine Datenfolge\" at (20,240) color black font SansSerif size 24\n  text \"f1-04b\" \"ist dabei h-sortiert, wenn man bei Entnahme jedes h-ten Elements ab\" at (20,270) color black font SansSerif size 24\n  text \"f1-04c\" \"einem beliebigen Startelement immer eine sortierte Folge erh\u2030lt\" at (20,300) color black font SansSerif size 24\n}\n{\n  text \"f1-05a\" \"Eine h-sortierte Datenfolge besteht daher aus h unabh\u2030ngig sortierten\" at (20,340) color black font SansSerif size 24\n  text \"f1-05b\" \"Datenfolgen, die einander \u00b8berlagern \" at (20,370) color black font SansSerif size 24\n}\n{\n  text \"f1-06a\" \"Das Vorgehen von Shellsort ist dabei, dass die Datenfolge sortiert\" at (20,410) color black font SansSerif size 24\n  text \"f1-06b\" \"wird, indem mit abnehmenden h mehrere h-Sortierungen ausgef\u00b8hrt\" at (20,440) color black font SansSerif size 24\n  text \"f1-06c\" \"werden, wobei am Schluss eine Sortierung mit h=1 erfolgt\" at (20,470) color black font SansSerif size 24\n}\n{\n  text \"f1-07a\" \"Die Folge zu verwendeter Werte f\u00b8r h wird auch als Inkrementfolge\" at (20,510) color black font SansSerif size 24\n  text \"f1-07b\" \"bezeichnet\" at (20,540) color black font SansSerif size 24\n}\nhideAll\ntext \"f2-01\" \"Der Algorithmus in Worten\" at (120,50) color black font SansSerif size 32 bold\n{\n  text \"f2-02a\" \"Es hat sich gezeigt, dass die Folge h[i+1]=3*h[i]+1 g\u00b8nstige\" at (20,100) color black font SansSerif size 24\n  text \"f2-02b\" \"Eigenschaften hat. Mit ihr l\u2030sst sich der Algorithmus wie folgt\" at (20,130) color black font SansSerif size 24\n  text \"f2-02c\" \"anpassen:\" at (20,160) color black font SansSerif size 24\n}\ntext \"f2-03\" \"1. Solange h<=n/9, setze h=3*h+1\" at (20,200) color black font SansSerif size 24\ntext \"f2-04\" \"2. Setze i=h\" at (20,240) color black font SansSerif size 24\n{\n  text \"f2-05a\" \"3. Speichere Element a[i] in einer Variablen v, und speichere i in\" at (20,280) color black font SansSerif size 24\n  text \"f2-05b\" \"    einer Variablen j\" at (20,310) color black font SansSerif size 24\n}\ntext \"f2-06\" \"4. Solange j>h ist und a[j-h]>v, setze a[j]=a[j-h] und j=j-h\" at (20,350) color black font SansSerif size 24\ntext \"f2-07\" \"5. Setze a[j]=v\" at (20,390) color black font SansSerif size 24\ntext \"f2-08\" \"6. Z\u2030hle i um eins hoch. Falls i<n, fahre fort mit Schritt 3\" at (20,430) color black font SansSerif size 24\ntext \"f2-09\" \"7. Setze h=h/3 (Integer-Division). Falls h>0, fahre fort mit Schritt 2\" at (20,470) color black font SansSerif size 24\n";
    private static final String SOURCE_CODE = "public void shellSort(int[] array) {\n  int i, j, dist, v;\n  for (dist = 1; dist < array.length / 9; dist = dist * 3 +1) ;\n  for (; dist > 0; dist /= 3) {\n    for (i = dist; i < array.length; i++) {\n      v = array[i];\n      j = i;\n      while (j >= dist && v < array[j - dist]) {\n        array[j] = array[j-dist]\n        j = j - dist;\n      }\n      array[j] = v;\n    }\n  }\n}";

    public void sort(int[] a) {
        this.nrAssigns = 0;
        this.nrComparisons = 0;
        this.sb.setLength(0);
        this.sb.append("%Animal 2.0\n");
        this.sb.append("title \"Shell Sort Animation\"\n");
        this.sb.append("author \"Jens Falk <Jens.Falk@epost.de>\"\n");
        this.sb.append(HEADER_TEXT);
        this.sb.append("hideAll\n");
        this.targetArray = this.createIntArray("array");
        this.toggleStep();
        this.codeSupport = this.createCode(SOURCE_CODE, "code");
        this.toggleStep();
        this.codeSupport.highlightCode(0);
        this.toggleStep();
        this.codeSupport.switchCodeLine(0, 1);
        this.jMarker = this.createArrayMarker(this.targetArray, 0, "j");
        this.toggleStep();
        this.codeSupport.switchCodeLine(1, 2);
        int oldDist = -1;
        this.sb.append("  text \"dist\" \"dist:\" offset (40, 20) from \"array\" E");
        int dist = 1;
        while (dist < a.length / 9) {
            this.toggleStep();
            if (oldDist != -1) {
                this.sb.append("  hide \"dist").append(oldDist).append("\"");
            }
            this.sb.append("  text \"dist").append(dist).append("\" offset (10, 0)");
            this.sb.append(" from \"dist\" baseline");
            oldDist = dist;
            dist = 3 * dist + 1;
        }
        this.toggleStep();
        this.codeSupport.switchCodeLine(2, 3);
        while (dist > 0) {
            this.toggleStep();
            if (dist != oldDist) {
                this.sb.append("  hide \"dist").append(oldDist).append("\"\n");
            }
            oldDist = dist;
            this.codeSupport.switchCodeLine(3, 4);
            int i = dist;
            while (i < this.targetArray.getLength()) {
                if (this.iMarker == null) {
                    this.iMarker = this.createArrayMarker(this.targetArray, i, "i");
                } else {
                    this.iMarker.moveArrayIndex(i);
                }
                ++this.nrAssigns;
                this.toggleStep();
                this.codeSupport.switchCodeLine(4, 5);
                int v = this.targetArray.getElementAt(i);
                this.targetArray.highlightArrayCell(i);
                this.toggleStep();
                this.codeSupport.switchCodeLine(5, 6);
                this.targetArray.unhighlightArrayElement(i);
                int j = i;
                if (this.jMarker == null) {
                    this.jMarker = this.createArrayMarker(this.targetArray, j, "j");
                } else {
                    this.jMarker.moveArrayIndex(j);
                }
                this.toggleStep();
                this.codeSupport.switchCodeLine(6, 7);
                while (j >= dist && v < this.targetArray.getElementAt(j - dist)) {
                    this.toggleStep();
                    this.codeSupport.switchCodeLine(7, 8);
                    ++this.nrComparisons;
                    ++this.nrAssigns;
                    this.targetArray.putElement(this.targetArray.getElementAt(j - dist), j);
                    this.targetArray.highlightArrayCell(j);
                    this.targetArray.unhighlightArrayCell(j - 1);
                    this.toggleStep();
                    this.codeSupport.switchCodeLine(8, 9);
                    this.jMarker.moveArrayIndex(j -= dist);
                    this.toggleStep();
                    this.codeSupport.switchCodeLine(9, 7);
                }
                this.toggleStep();
                this.codeSupport.switchCodeLine(7, 11);
                ++this.nrComparisons;
                ++this.nrAssigns;
                this.targetArray.putElement(v, j);
                this.targetArray.highlightArrayElement(j);
                this.toggleStep();
                this.codeSupport.switchCodeLine(11, 4);
                this.targetArray.unhighlightArrayElement(j);
                ++i;
            }
            this.endStep();
            this.codeSupport.switchCodeLine(4, 3);
            dist /= 3;
        }
        this.codeSupport.unhighlightCode(3);
        this.toggleStep();
        this.endAnimGeneration();
        this.endStep();
        this.sb.append("{\n  hideAll\n  text \"eoa\" \"Ende der Animation\" at (120,50) color black font SansSerif size 32\n  text \"comps\" \"Es wurden \" +$\"nrComparisons\" asInt +\" Vergleiche\" at (20,100) color black font SansSerif size 24\n  text \"swaps\" \"und \" +$\"nrAssignments\" asInt +\" Zuweisungen durchgef\u00b8hrt.\" at (20,130) color black font SansSerif size 24\n}");
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    public String getName() {
        return "Shell Sort (h' = 3*h+1)";
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getCodeExample() {
        return SOURCE_CODE;
    }

    public Locale getContentLocale() {
        return Locale.GERMANY;
    }
}

