/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.IntArray;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.properties.ArrayMarkerProperties;
import animalscriptapi.properties.ArrayProperties;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.TicksTiming;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.SortingAlgorithm;
import java.awt.Color;
import java.util.Hashtable;
import java.util.Locale;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionSortDemo2
extends SortingAlgorithm {
    private static final String DESCRIPTION = "Dieser Generator sortiert das vom Nutzer eingegebene Array mittels Selection Sort.\nUm ein Array der L\u2030nge n zu sortieren, wird das Minimum gesucht, also das Element mit dem kleinsten Sortierschl\u00b8ssel.\nDas Minimum wird dann mit dem ersten Element des Arrays vertauscht. Somit erh\u2030lt man links ein sortiertes Teilarray der L\u2030nge 1 und rechts ein unsortiertes der L\u2030nge n-1.\nAnschlie\ufb02end wird der Algorithmus auf das unsortierte Teilarray angewendet.";
    private static final String HEADER_TEXT = "\ntext \"f1-01\" \"Selection Sort\" at (120,50) color black font SansSerif size 32 bold\n{\ntext \"f1-02a\" \"Das naheliegendste Verfahren zur Sortierung\" at (20,100) color black font SansSerif size 24\ntext \"f1-02b\" \"ist Sortieren durch Auswahl, auch als\" at (20,130) color black font SansSerif size 24\ntext \"f1-02c\" \"Selection Sort bezeichnet.\" at (20,160) color black font SansSerif size 24\n}\nhideAll\ntext \"f2-01\" \"Der Algorithmus in Worten\" at (120,50) color black font SansSerif size 32 bold\ntext \"f2-02\" \"1. Setze i=0\" at (20,100) color black font SansSerif size 24\ntext \"f2-03\" \"2. Suche ab Position i das kleinste Element im Feld\" at (20,140) color black font SansSerif size 24\ntext \"f2-04\" \"3. Vertausche das kleinste Element mit dem Element ab Position i\" at (20,180) color black font SansSerif size 24\ntext \"f2-05\" \"4. Setze i=i+1 und fahre bei Schritt 2 fort bis i==n\" at (20,220) color black font SansSerif size 24\n";
    private static final String SOURCE_CODE = "public void selectionSort(int[] array)\n{\n  int i, j, minIndex;\n  for (i=0; i<array.length - 1; i++)\n  {\n    minIndex = i;\n    for (j=i+1; j<array.length; j++)\n      if (array[j] < array[minIndex])\n        minIndex = j;\n    swap(array, i, minIndex);\n  }\n}";
    private Language lang;
    private ArrayProperties arrayProps;
    private ArrayMarkerProperties ami;
    private ArrayMarkerProperties amj;
    private ArrayMarkerProperties amMid;

    public void init() {
        this.lang = new AnimalScript("SelectionSort Demo", "Dr. Guido R\u02c6\ufb02ling", 640, 480);
        this.arrayProps = new ArrayProperties();
        this.arrayProps.set("color", Color.RED);
        this.arrayProps.set("filled", true);
        this.arrayProps.set("fillColor", Color.GRAY);
        this.ami = new ArrayMarkerProperties();
        this.ami.set("color", Color.BLUE);
        this.amj = new ArrayMarkerProperties();
        this.amj.set("color", Color.GREEN);
        this.amMid = new ArrayMarkerProperties();
        this.amMid.set("color", Color.RED);
    }

    public void selectionSortPureJava(int[] inputArray) {
        int i = 0;
        while (i < inputArray.length - 1) {
            int minIndex = i;
            int j = i + 1;
            while (j < inputArray.length) {
                if (inputArray[j] < inputArray[minIndex]) {
                    minIndex = j;
                }
                ++j;
            }
            this.swap(inputArray, i, minIndex);
            ++i;
        }
    }

    public void selectionSortWithIntArray(int[] arrayContents) {
        IntArray array = this.lang.newIntArray(new Coordinates(10, 30), arrayContents, "array", null, this.arrayProps);
        TicksTiming defaultTiming = new TicksTiming(15);
        int i = 0;
        while (i < array.getLength() - 1) {
            int minIndex = i;
            int j = i + 1;
            while (j < array.getLength()) {
                if (array.getData(j) < array.getData(minIndex)) {
                    minIndex = j;
                }
                ++j;
            }
            array.swap(i, minIndex, null, defaultTiming);
            ++i;
        }
    }

    public void selectionSortWithIntArrayAndPointers(int[] arrayContents) {
        IntArray array = this.lang.newIntArray(new Coordinates(10, 30), arrayContents, "array", null, this.arrayProps);
        TicksTiming defaultTiming = new TicksTiming(15);
        ArrayMarker i = this.lang.newArrayMarker(array, 0, "i", null, this.ami);
        ArrayMarker j = this.lang.newArrayMarker(array, 0, "j", null, this.amj);
        ArrayMarker minIndex = this.lang.newArrayMarker(array, 0, "minIndex", null, this.amMid);
        while (i.getPosition() < array.getLength() - 1) {
            minIndex.move(i.getPosition(), null, defaultTiming);
            j.move(i.getPosition() + 1, null, defaultTiming);
            while (j.getPosition() < array.getLength()) {
                if (array.getData(j.getPosition()) < array.getData(minIndex.getPosition())) {
                    minIndex = j;
                }
                j.increment(null, defaultTiming);
            }
            array.swap(i.getPosition(), minIndex.getPosition(), null, new TicksTiming(15));
            i.increment(null, defaultTiming);
        }
        System.err.println(this.dumpArray(array));
        System.err.println(this.lang.getAnimationCode());
    }

    public String dumpArray(int[] a) {
        StringBuilder sb2 = new StringBuilder(256);
        sb2.append("[");
        int[] nArray = a;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            int element = nArray[n];
            sb2.append(element).append(' ');
            ++n;
        }
        sb2.append("]");
        return sb2.toString();
    }

    public String dumpArray(IntArray a) {
        return this.dumpArray(a.getData());
    }

    @Override
    public void sort(int[] b) {
        this.nrAssigns = 0;
        this.nrComparisons = 0;
        int nrElems = b.length;
        this.sb.setLength(0);
        this.sb.append("%Animal 2.0\n");
        this.sb.append("title \"Selection Sort Animation\"\n");
        this.sb.append("author \"Dr. Guido Roessling (roessling@acm.org>\"\n");
        this.sb.append(HEADER_TEXT);
        this.sb.append("hideAll\n");
        this.toggleStep();
        this.targetArray = this.createIntArray("array");
        this.codeSupport = this.createCode(SOURCE_CODE, "code");
        this.codeSupport.highlightCode(0);
        this.startStep();
        this.codeSupport.unhighlightCode(0);
        this.iMarker = this.createArrayMarker(this.targetArray, 0, "i");
        this.jMarker = this.createArrayMarker(this.targetArray, 0, "j");
        this.codeSupport.highlightCode(2);
        this.toggleStep();
        this.codeSupport.unhighlightCode(2);
        this.codeSupport.highlightCode(3);
        this.toggleStep();
        this.codeSupport.unhighlightCode(3);
        int i = 0;
        while (i < nrElems - 1) {
            if (i == 0) {
                this.iMarker.moveArrayIndex(i);
                this.codeSupport.highlightCode(4);
                this.endStep();
            } else {
                this.targetArray.highlightArrayCell(i - 1);
                this.iMarker.moveArrayIndex(i);
                this.codeSupport.highlightCode(4);
                this.endStep();
            }
            int minIndex = i;
            ++this.nrAssigns;
            this.startStep();
            this.codeSupport.unhighlightCode(4);
            this.targetArray.highlightArrayElement(minIndex);
            this.codeSupport.highlightCode(6);
            this.toggleStep();
            this.codeSupport.unhighlightCode(6);
            ++this.nrAssigns;
            int j = i + 1;
            while (j < nrElems) {
                ++this.nrAssigns;
                this.jMarker.moveArrayIndex(j);
                this.codeSupport.highlightCode(7);
                ++this.nrComparisons;
                this.toggleStep();
                this.codeSupport.unhighlightCode(7);
                this.codeSupport.highlightCode(9);
                this.toggleStep();
                this.codeSupport.unhighlightCode(9);
                if (this.targetArray.getElementAt(j) < this.targetArray.getElementAt(minIndex)) {
                    this.targetArray.unhighlightArrayElement(minIndex);
                    minIndex = j;
                    ++this.nrAssigns;
                    this.targetArray.highlightArrayElement(minIndex);
                    this.codeSupport.highlightCode(11);
                    this.toggleStep();
                    this.codeSupport.unhighlightCode(11);
                }
                ++j;
            }
            this.codeSupport.highlightCode(7);
            this.toggleStep();
            this.codeSupport.unhighlightCode(7);
            this.targetArray.highlightArrayElement(i);
            this.nrAssigns += 3;
            this.targetArray.swap(i, minIndex);
            this.codeSupport.highlightCode(14);
            this.toggleStep();
            this.targetArray.unhighlightArrayElement(i);
            this.targetArray.unhighlightArrayElement(minIndex);
            this.toggleStep();
            this.codeSupport.unhighlightCode(14);
            ++i;
        }
        this.codeSupport.highlightCode(4);
        this.toggleStep();
        this.codeSupport.unhighlightCode(4);
        this.targetArray.highlightArrayCell(nrElems - 1);
        this.targetArray.highlightArrayCell(nrElems - 2);
        this.toggleStep();
        this.endAnimGeneration();
        this.endStep();
        this.sb.append("{\n  hideAll\n  text \"eoa\" \"Ende der Animation\" at (120,50) color black font SansSerif size 32\n  text \"comps\" \"Es wurden \" +$\"nrComparisons\" asInt +\" Vergleiche\" at (20,100) color black font SansSerif size 24\n  text \"swaps\" \"und \" +$\"nrAssignments\" asInt +\" Zuweisungen durchgef\u00b8hrt.\" at (20,130) color black font SansSerif size 24\n}");
    }

    @Override
    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    @Override
    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    public String getName() {
        return "Selection Sort";
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        this.setParameters(props, primitives);
        int[] theArray = (int[])primitives.get("array");
        this.sort(theArray);
        return this.sb.toString();
    }

    public Locale getContentLocale() {
        return Locale.GERMANY;
    }

    public static void main(String[] args) {
        SelectionSortDemo2 ssd = new SelectionSortDemo2();
        ssd.init();
        int[] original = new int[]{1, 13, 7, 2, 11};
        int[] copy = new int[5];
        System.arraycopy(original, 0, copy, 0, 5);
        ssd.selectionSortPureJava(copy);
        System.arraycopy(original, 0, copy, 0, 5);
        ssd.selectionSortWithIntArray(copy);
        System.arraycopy(original, 0, copy, 0, 5);
        ssd.selectionSortWithIntArrayAndPointers(copy);
    }
}

