/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import generator.Generator;
import generatorImplementations.SortingAlgorithm;
import java.util.Locale;
import net.algoanim.aads.AnimatedIntArray;
import net.algoanim.aads.AnimatedIntArrayMarker;

public class QuickSortEN
extends SortingAlgorithm
implements Generator {
    private static final String DESCRIPTION = "This algorithm performs Quicksort.\nThe pivot element is the last element of the sub-array.";
    private static final String HEADER_TEXT = "\ntext \"f2-01\" \"Verbal description\" at (120,50) color black font SansSerif size 32 bold\ntext \"f2-02\" \"1. Determine a pivot element pivot\" at (20,100) color black font SansSerif size 24\n{\ntext \"f2-03\" \"2. Partition so that all values before index i are smaller,\" at (20,140) color black font SansSerif size 24\ntext \"f2-03a\" \"all values after index i are bigger than pivot.\" at (20,180) color black font SansSerif size 24\n}\ntext \"f2-04\" \"3. Swap pivot with the element at position i, if needed\" at (20,220) color black font SansSerif size 24\ntext \"f2-05\" \"4. Start quicksort(l, i-1)\" at (20,260) color black font SansSerif size 24\ntext \"f2-05\" \"5. Start quicksort(i+1, r)\" at (20,300) color black font SansSerif size 24\n";
    private static final String SOURCE_CODE = "public void quickSort(int[] array, int l, int r)\n{\n  int i, j, pivot;\n  if (r>l)\n  {\n    pivot = array[r];\n    for (i = l; j = r - 1; i < j; )\n    {\n      while (array[i] <= pivot && j > i)\n        i++;\n      while (pivot < array[j] && j > i)\n        j--;\n      if (i < j)\n        swap(array, i, j);\n    }\n    if (pivot < array[i])\n      swap(array, i, r);\n    else\n      i=r;\n    quickSort(array, l, i - 1);\n    quickSort(array, i + 1, r);\n  }\n}";
    private int pointerCounter = 0;

    public void sort(int[] a) {
        this.nrAssigns = 0;
        this.nrComparisons = 0;
        this.sb.setLength(0);
        this.sb.append("%Animal 2.0\n");
        this.sb.append("title \"Quick Sort Animation\"\n");
        this.sb.append("author \"Dr. Guido Roessling (roessling@acm.org>\"\n");
        this.sb.append(HEADER_TEXT);
        this.sb.append("hideAll\n");
        this.targetArray = this.createIntArray("array");
        this.toggleStep();
        this.codeSupport = this.createCode(SOURCE_CODE, "code");
        this.toggleStep();
        this.targetArray.highlightArrayCell(0, a.length - 1);
        this.quickSort(this.targetArray, 0, a.length - 1);
        this.toggleStep();
        this.endAnimGeneration();
        this.endStep();
        this.sb.append("{\n  hideAll\n  text \"eoa\" \"Ende der Animation\" at (120,50) color black font SansSerif size 32\n  text \"comps\" \"Es wurden \" +$\"nrComparisons\" asInt +\" Vergleiche\" at (20,100) color black font SansSerif size 24\n  text \"swaps\" \"und \" +$\"nrAssignments\" asInt +\" Zuweisungen durchgef\u00b8hrt.\" at (20,130) color black font SansSerif size 24\n}");
    }

    private void quickSort(AnimatedIntArray array, int l, int r) {
        this.codeSupport.highlightCode(0);
        this.toggleStep();
        this.codeSupport.switchCodeLine(0, 2);
        ++this.pointerCounter;
        AnimatedIntArrayMarker localIMarker = new AnimatedIntArrayMarker(array, 0, "i" + this.pointerCounter, this.sb, "i");
        ++this.pointerCounter;
        AnimatedIntArrayMarker localJMarker = new AnimatedIntArrayMarker(array, 0, "j" + this.pointerCounter, this.sb, "j");
        this.toggleStep();
        this.codeSupport.switchCodeLine(2, 3);
        ++this.pointerCounter;
        AnimatedIntArrayMarker localPivotMarker = new AnimatedIntArrayMarker(array, 0, "pivot" + this.pointerCounter, this.sb, "pivot");
        this.toggleStep();
        this.codeSupport.unhighlightCode(3);
        if (r > l) {
            this.toggleStep();
            this.codeSupport.switchCodeLine(3, 5);
            int pivot = array.getElementAt(r);
            localPivotMarker.moveArrayIndex(r);
            ++this.nrAssigns;
            this.toggleStep();
            this.codeSupport.unhighlightCode(5);
            int i = l;
            int j = r - 1;
            while (i < j) {
                this.codeSupport.highlightCode(6);
                localIMarker.moveArrayIndex(i);
                localJMarker.moveArrayIndex(j);
                this.toggleStep();
                this.codeSupport.switchCodeLine(6, 8);
                while (array.getElementAt(i) <= pivot && j > i) {
                    this.toggleStep();
                    ++this.nrComparisons;
                    this.codeSupport.switchCodeLine(8, 9);
                    localIMarker.moveArrayIndex(++i);
                    this.toggleStep();
                    this.codeSupport.switchCodeLine(9, 8);
                }
                ++this.nrComparisons;
                this.toggleStep();
                this.codeSupport.switchCodeLine(8, 10);
                while (pivot < array.getElementAt(j) && j > i) {
                    this.toggleStep();
                    ++this.nrComparisons;
                    this.codeSupport.switchCodeLine(10, 11);
                    localJMarker.moveArrayIndex(--j);
                    this.toggleStep();
                    this.codeSupport.switchCodeLine(11, 10);
                }
                ++this.nrComparisons;
                this.toggleStep();
                this.codeSupport.switchCodeLine(10, 12);
                if (i < j) {
                    this.toggleStep();
                    this.codeSupport.switchCodeLine(12, 13);
                    array.swap(i, j);
                }
                this.toggleStep();
                this.codeSupport.unhighlightCode(13);
                this.codeSupport.unhighlightCode(12);
            }
            this.codeSupport.switchCodeLine(6, 15);
            this.toggleStep();
            if (pivot < array.getElementAt(i)) {
                this.codeSupport.switchCodeLine(15, 16);
                array.swap(i, r);
                localPivotMarker.moveArrayIndex(i);
                this.toggleStep();
                this.codeSupport.unhighlightCode(16);
            } else {
                i = r;
                this.codeSupport.switchCodeLine(15, 18);
                localIMarker.moveArrayIndex(r);
                this.toggleStep();
                this.codeSupport.unhighlightCode(18);
            }
            array.highlightArrayElement(i);
            ++this.nrComparisons;
            this.toggleStep();
            this.codeSupport.highlightCode(19);
            this.toggleStep();
            this.codeSupport.unhighlightCode(19);
            array.unhighlightArrayCell(i, r);
            this.quickSort(array, l, i - 1);
            this.toggleStep();
            array.highlightArrayCell(l, r);
            this.codeSupport.highlightCode(20);
            this.toggleStep();
            this.codeSupport.unhighlightCode(20);
            array.unhighlightArrayCell(l, i);
            this.quickSort(array, i + 1, r);
        }
        this.endStep();
        this.codeSupport.highlightCode(21);
        this.endStep();
        this.codeSupport.highlightCode(22);
        this.toggleStep();
        array.unhighlightArrayCell(l, r);
    }

    protected String getAlgorithmDescription() {
        return DESCRIPTION;
    }

    protected String getAlgorithmCode() {
        return SOURCE_CODE;
    }

    public String getName() {
        return "Quicksort (pivot=last)";
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public String getCodeExample() {
        return SOURCE_CODE;
    }

    public Locale getContentLocale() {
        return Locale.US;
    }
}

