/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.exceptions.LineNotExistsException;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.IntArray;
import animalscriptapi.primitives.IntMatrix;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.StringArray;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.CompressionAlgorithm;
import java.awt.Color;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTFDecoding
extends CompressionAlgorithm
implements Generator {
    private static String lettersOrdered;
    private static final int inputLimit = 30;
    private static final String DESCRIPTION = "Das Move to Front - Verfahren eignet sich f\u00b8r eine weitere Bearbeitung Burrows Wheeler transformierter Daten. Der Eingabestring wird in eine Zahlenfolge verarbeitet, die sich wiederum verbessert Huffman kodieren l\u2030sst.";
    private static final String SOURCE_CODE = "Der Algorithmus wird durch eine Animation demonstriert. Es handelt sich hier um einen Dekodierungsalgorithmus. Ihre Eingabe wird zun\u2030chst durch die entsprechende Kodierung kodiert. Erst diese Daten werden dekodiert.";

    public MTFDecoding() {
        this(new AnimalScript("Move to Front Decoding", "Florian Lindner", 800, 600));
    }

    public MTFDecoding(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void compress(String[] text) throws LineNotExistsException {
        String ein = "";
        String[] t = new String[Math.min(text.length, 30)];
        int i = 0;
        while (i < t.length) {
            t[i] = text[i];
            ein = String.valueOf(ein) + text[i];
            ++i;
        }
        text = t;
        Text topic = this.lang.newText(new Coordinates(20, 50), "Move to Front Decoding", "Topic", null, tptopic);
        Rect topicRect = this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        String input = "";
        int i2 = 0;
        while (i2 < text.length) {
            input = String.valueOf(input) + text[i2];
            ++i2;
        }
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 40, topic, "SW"), "Die Eingabe ist:  ", "line1", null, tpsteps);
        Text step12 = this.lang.newText(new Offset(10, -5, step1, "SE"), input, "line1", null, tpsteps);
        step12.changeColor(null, Color.RED, null, null);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 30, step1, "SW"), "Durch die Move to Front Kodierung erhalten wir:  ", "line1", null, tpsteps);
        String in = MTFDecoding.transformMTF(text);
        Text step22 = this.lang.newText(new Offset(10, -5, step2, "SE"), in, "line1", null, tpsteps);
        Text step23 = this.lang.newText(new Offset(10, -5, step22, "SE"), "und", "line1", null, tpsteps);
        Text step24 = this.lang.newText(new Offset(10, -5, step23, "SE"), lettersOrdered, "line1", null, tpsteps);
        step12.changeColor(null, Color.BLACK, null, null);
        step22.changeColor(null, Color.RED, null, null);
        step24.changeColor(null, Color.RED, null, null);
        Text step3 = this.lang.newText(new Offset(0, 30, step2, "SW"), "Wir wollen die Ausgabe nun wieder dekodieren.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step4 = this.lang.newText(new Offset(10, 40, step3, "SW"), "- Erweitere die Ausgabe durch den Buchstaben an entsprechender Indexstelle. ", "line2", null, tpsteps);
        Text step41 = this.lang.newText(new Offset(0, 20, step4, "SW"), "- Der eben genannte Buchstbabe wird an die erste Stelle verschoben, wobei", "line2", null, tpsteps);
        Text step42 = this.lang.newText(new Offset(0, 20, step41, "SW"), "  die anderen Buchstaben nach rechts rotieren.", "line2", null, tpsteps);
        Text step43 = this.lang.newText(new Offset(0, 20, step42, "SW"), "- F\u00b8hre dies fort, bis die Eingabeziffern vollst\u2030ndig gelesen sind.", "line2", null, tpsteps);
        int[][] ind = new int[1][lettersOrdered.length()];
        int i3 = 0;
        while (i3 < ind[0].length) {
            ind[0][i3] = i3;
            ++i3;
        }
        IntMatrix indizes = this.lang.newIntMatrix(new Offset(155, 35, step43, "SW"), ind, "ind", null, mp);
        String[] l = new String[lettersOrdered.length()];
        int i4 = 0;
        while (i4 < l.length) {
            l[i4] = " " + lettersOrdered.charAt(i4) + "  ";
            ++i4;
        }
        StringArray let = this.lang.newStringArray(new Offset(-7, 7, indizes, "SW"), l, "letters", null, ap);
        Text eingabe = this.lang.newText(new Offset(0, 200, step42, "SW"), "Eingabe:  ", "in", null, tpsteps);
        int[] inData = new int[in.length()];
        int i5 = 0;
        while (i5 < in.length()) {
            inData[i5] = Integer.parseInt("" + in.charAt(i5));
            ++i5;
        }
        IntArray inArray = this.lang.newIntArray(new Offset(30, -5, eingabe, "NE"), inData, "inArray", null, ap);
        ArrayMarker am = this.lang.newArrayMarker(inArray, 0, "am", null, amp);
        inArray.highlightCell(0, null, null);
        String result = "";
        Text ausgabeLabel = this.lang.newText(new Offset(0, 55, eingabe, "SW"), "Ausgabe:", "ausgabe", null, tpsteps);
        Text ausgabe = this.lang.newText(new Offset(10, -5, ausgabeLabel, "SE"), result, "ausgabe", null, tpsteps);
        ausgabe.changeColor(null, Color.BLUE, null, null);
        int i6 = 0;
        while (i6 < in.length()) {
            if (i6 != 0) {
                inArray.unhighlightCell(i6 - 1, null, null);
                am.move(i6, null, null);
                inArray.highlightCell(i6, null, null);
            }
            this.lang.nextStep();
            result = String.valueOf(result) + lettersOrdered.charAt(Integer.parseInt("" + in.charAt(i6)));
            ausgabe.setText(result, null, null);
            lettersOrdered = String.valueOf(lettersOrdered.charAt(Integer.parseInt("" + in.charAt(i6)))) + lettersOrdered.replace("" + lettersOrdered.charAt(Integer.parseInt("" + in.charAt(i6))), "");
            int j = 0;
            while (j < lettersOrdered.length()) {
                let.put(j, " " + lettersOrdered.charAt(j) + "  ", null, null);
                ++j;
            }
            this.lang.nextStep();
            ++i6;
        }
        Text fazit = this.lang.newText(new Offset(0, 60, ausgabeLabel, "SW"), "Die Ausgabe entspricht genau der Eingabe", "Ausgabe", null, tpsteps);
    }

    public static String transformMTF(String[] text) {
        String letters = "";
        char small = '\u0000';
        int i = 0;
        while (i < text.length) {
            char tmp = '\u0100';
            int j = 0;
            while (j < text.length) {
                if (text[j].charAt(0) > small && text[j].charAt(0) < tmp) {
                    tmp = text[j].charAt(0);
                }
                ++j;
            }
            small = tmp;
            if (small != '\u0100') {
                letters = String.valueOf(letters) + small;
            }
            ++i;
        }
        lettersOrdered = letters;
        String result = "";
        int i2 = 0;
        while (i2 < text.length) {
            result = String.valueOf(result) + letters.indexOf(text[i2]);
            letters = String.valueOf(text[i2]) + letters.replace(text[i2], "");
            ++i2;
        }
        return result;
    }

    public static String getSOURCE_CODE() {
        return SOURCE_CODE;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return "Move to Front Decoding";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        try {
            this.compress(strArray);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }
}

