/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.exceptions.LineNotExistsException;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.IntArray;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.SourceCode;
import animalscriptapi.primitives.StringMatrix;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.CompressionAlgorithm;
import java.awt.Color;
import java.util.Hashtable;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LZWDecoding
extends CompressionAlgorithm
implements Generator {
    private SourceCode sc;
    private static final int inputLimit = 24;
    private static final String DESCRIPTION = "Die Lempel Ziv Welch Dekodierung dient dazu, die Daten durch den gleichnamigen Kodierungsalgorithmus komprimierten Daten wiederherzustellen. Hierbei ist es nicht n\u02c6tig, dass das automatisch generierte W\u02c6rterbuch der Kodierung verwendet wird. Auch bei der Dekodierung kann dieses W\u02c6rterbuch wieder automatisch erstellt werden.";
    private static final String SOURCE_CODE = "Der Algorithmus wird in einer Animation demonstriert. Um die grafische Animation in voller Gr\u02c6\ufb02e darstellen zu k\u02c6nnen, wird die Eingabe auf 24 Buchstaben begrenzt. Es handelt sich hier um einen Dekodierungsalgorithmus. Ihre Eingabe wird zun\u2030chst durch die entsprechende Kodierung kodiert. Erst diese Daten werden dekodiert.\n\npublic static void decode(String input) {\n  StringTokenizer t = new StringTokenizer(input);\n  int cnt = t.countTokens();\n  String w, k, result = \"\";\n  int dicCnt = 256;\n  for (int i = 0; i < cnt; i++) {\n    int tmp = Integer.parseInt(t.nextToken());\n    if (tmp < 256) {\n\t   k = \"\" + (char)tmp;\n\t   if (w.equals(\"\")) {\n\t     w = k;\n\t     continue;\n\t   }\n\t   else if (!dict.contains(w + k)) {\n\t     result += w;\n\t     dict.put(dicCnt, w + k);\n        dicCnt++;\n        w = k;\n      }\n    }\n    else {  // dict entry\n       result += w;\n       String add = dict.get(tmp);\n       dict.put(dicCnt, w + add.charAt(0));\n       dicCnt++;\n       w = add;\n    }\n  }\n  result += k;\n }";

    public LZWDecoding(Language language) {
        this.lang = language;
    }

    public LZWDecoding() {
        this(new AnimalScript("LZW Decoding", "Florian Lindner", 1152, 768));
        this.lang.setStepMode(true);
    }

    public void decode(String[] text) throws LineNotExistsException {
        String ein = "";
        String[] t = new String[Math.min(text.length, 24)];
        int i = 0;
        while (i < t.length) {
            t[i] = text[i];
            ein = String.valueOf(ein) + text[i];
            ++i;
        }
        text = t;
        String input = "";
        int i2 = 0;
        while (i2 < text.length) {
            input = String.valueOf(input) + text[i2];
            ++i2;
        }
        String chiffre = LZWDecoding.code(input);
        StringTokenizer initialTokenizer = new StringTokenizer(chiffre);
        int tokens = initialTokenizer.countTokens();
        int[] chiffreArray = new int[tokens];
        int i3 = 0;
        while (i3 < tokens) {
            chiffreArray[i3] = Integer.parseInt(initialTokenizer.nextToken());
            ++i3;
        }
        Text topic = this.lang.newText(new Coordinates(20, 50), "LZW Decoding", "Topic", null, tptopic);
        Rect topicRect = this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        this.lang.nextStep();
        Text in1 = this.lang.newText(new Offset(0, 50, topic, "SW"), "Die LZW-Kodierung von  " + input + " ergibt: " + LZWDecoding.code(input), "in", null, tpsteps);
        this.lang.nextStep();
        Text algoinWords = this.lang.newText(new Offset(0, 50, in1, "SW"), "Der Algorithmus in Worten", "inWords", null, tpwords);
        this.lang.nextStep();
        Text step0 = this.lang.newText(new Offset(0, 30, algoinWords, "SW"), "0) Der Algorithmus bildet sich w\u2030hrend der Laufzeit sein eigenes W\u02c6rterbuch. Einzelne Zeichen", "line0", null, tpsteps);
        Text step01 = this.lang.newText(new Offset(0, 20, step0, "SW"), "    werden gem\u2030\ufb02 ASCII-Standard kodiert. F\u00b8r diese Zeichen sind also im W\u02c6rterbuch die Eintr\u2030ge", "line0", null, tpsteps);
        Text step02 = this.lang.newText(new Offset(0, 20, step01, "SW"), "    0 bis 255 reserviert. F\u00b8r jede neue Kodierung wird sukzessive ab 256 ein neuer Eintrag angelegt.", "line0", null, tpsteps);
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 40, step02, "SW"), "1) Lese den Eingabestring zahlenweise beginnend an der zweiten Zahl ein. Sei z die eingelesene Zahl.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 40, step1, "SW"), "2) Ist z im W\u02c6rterbuch vorhanden, f\u00b8ge die Kodierung des Pr\u2030fixes von z konkateniert mit dem", "line2", null, tpsteps);
        Text step21 = this.lang.newText(new Offset(0, 20, step2, "SW"), "   dem ersten Buchstaben der Kodierung von z dem W\u02c6rterbuch an der n\u2030chsten freien Stelle hinzu.", "line2", null, tpsteps);
        this.lang.nextStep();
        Text step3 = this.lang.newText(new Offset(0, 40, step21, "SW"), "3) Ansonsten erweitere die Ausgabe um die Kodierung des Pr\u2030fixes von z, setzte das Pr\u2030fix auf z, und fahre bei der", "line3", null, tpsteps);
        Text step31 = this.lang.newText(new Offset(0, 20, step3, "SW"), "   n\u2030chsten Zahl fort.", "line31", null, tpsteps);
        this.lang.nextStep();
        algoinWords.hide();
        step0.hide();
        step01.hide();
        step02.hide();
        step1.hide();
        step2.hide();
        step21.hide();
        step3.hide();
        step31.hide();
        this.lang.nextStep();
        in1.setText("Wir wollen " + chiffre + " nun dekodieren.", null, null);
        this.lang.nextStep();
        in1.hide();
        IntArray intArray = this.lang.newIntArray(new Offset(0, 25, in1, "SW"), chiffreArray, "stringArray", null, ap);
        ArrayMarker am = this.lang.newArrayMarker(intArray, 0, "i", null, amp);
        this.lang.nextStep();
        this.sc = this.lang.newSourceCode(new Offset(0, 25, intArray, "SW"), "codeName", null, scp);
        this.sc.addCodeLine("public static void decode(String input) {", null, 0, null);
        this.sc.addCodeLine("StringTokenizer t = new StringTokenizer(input);", null, 1, null);
        this.sc.addCodeLine("int cnt = t.countTokens();", null, 1, null);
        this.sc.addCodeLine("String w, k, result;", null, 1, null);
        this.sc.addCodeLine("int dicCnt = 256;", null, 1, null);
        this.sc.addCodeLine("for (int i = 0; i < cnt; i++) {;", null, 1, null);
        this.sc.addCodeLine("int tmp = Integer.parseInt(t.nextToken());", null, 2, null);
        this.sc.addCodeLine("if (tmp < 256) {", null, 2, null);
        this.sc.addCodeLine("k = (char)tmp;", null, 3, null);
        this.sc.addCodeLine("if (w.length() == 0) {", null, 3, null);
        this.sc.addCodeLine("w = k;", null, 4, null);
        this.sc.addCodeLine("continue;", null, 4, null);
        this.sc.addCodeLine("}", null, 3, null);
        this.sc.addCodeLine("else if (!dict.contains(w + k)) {", null, 3, null);
        this.sc.addCodeLine("result += w;", null, 4, null);
        this.sc.addCodeLine("dict.put(dicCnt, w + k);", null, 4, null);
        this.sc.addCodeLine("dicCnt++;", null, 4, null);
        this.sc.addCodeLine("w = k;", null, 4, null);
        this.sc.addCodeLine("}", null, 3, null);
        this.sc.addCodeLine("}", null, 2, null);
        this.sc.addCodeLine("else {  // dict entry -> greater than 255", null, 2, null);
        this.sc.addCodeLine("result += w;", null, 3, null);
        this.sc.addCodeLine("String add = dict.get(tmp);", null, 3, null);
        this.sc.addCodeLine("dict.put(dicCnt, w + add.charAt(0));", null, 3, null);
        this.sc.addCodeLine("dicCnt++;", null, 3, null);
        this.sc.addCodeLine("w = add;", null, 3, null);
        this.sc.addCodeLine("}", null, 2, null);
        this.sc.addCodeLine("}", null, 1, null);
        this.sc.addCodeLine("result += k;", null, 1, null);
        this.sc.addCodeLine("}", null, 0, null);
        this.lang.nextStep();
        Text wLabel = this.lang.newText(new Offset(0, 25, this.sc, "SW"), "w: ", "w", null, tpsteps);
        Text kLabel = this.lang.newText(new Offset(0, 20, wLabel, "SW"), "k:  ", "k", null, tpsteps);
        Text dicLabel = this.lang.newText(new Offset(0, 25, kLabel, "SW"), "dicCnt: ", "dicCnt", null, tpsteps);
        Text ausgabeLabel = this.lang.newText(new Offset(0, 25, dicLabel, "SW"), "Ausgabe: ", "ausgabeLabel", null, tpsteps);
        ausgabeLabel.changeColor(null, Color.RED, null, null);
        Text ausgabe = this.lang.newText(new Offset(15, -4, ausgabeLabel, "SE"), "", "ausgabe", null, tpsteps);
        ausgabe.changeColor(null, Color.BLUE, null, null);
        this.sc.highlight(0, 0, false);
        this.lang.nextStep();
        this.sc.toggleHighlight(0, 0, false, 1, 0);
        StringTokenizer to = new StringTokenizer(chiffre);
        this.lang.nextStep();
        this.sc.toggleHighlight(1, 0, false, 2, 0);
        int cnt = to.countTokens();
        this.lang.nextStep();
        this.sc.toggleHighlight(2, 0, false, 3, 0);
        String w = "";
        String k = "";
        String result = "";
        this.lang.nextStep();
        this.sc.toggleHighlight(3, 0, false, 4, 0);
        int dicCnt = 256;
        dicLabel.setText("dicCnt: " + dicCnt, null, null);
        String[][] dictData = new String[24][2];
        int i4 = 0;
        while (i4 < 24) {
            dictData[i4][0] = "";
            dictData[i4][1] = "";
            ++i4;
        }
        StringMatrix dic = this.lang.newStringMatrix(new Offset(200, -50, intArray, "E"), dictData, "dict", null, mp);
        int matrixCount = 0;
        Hashtable<Integer, String> dict = new Hashtable<Integer, String>();
        int i5 = 0;
        while (i5 < 256) {
            dict.put(i5, "" + (char)i5);
            ++i5;
        }
        this.lang.nextStep();
        this.sc.toggleHighlight(4, 0, false, 5, 0);
        i5 = 0;
        while (i5 < cnt - 1) {
            if (i5 > 0) {
                intArray.unhighlightCell(i5 - 1, null, null);
            }
            this.lang.nextStep();
            this.sc.unhighlight(5, 0, false);
            this.sc.highlight(6, 0, false);
            int tmp = Integer.parseInt(to.nextToken());
            this.lang.nextStep();
            this.sc.toggleHighlight(6, 0, false, 7, 0);
            if (tmp < 256) {
                this.lang.nextStep();
                this.sc.unhighlight(7, 0, false);
                this.sc.highlight(8, 0, false);
                k = "" + (char)tmp;
                kLabel.setText("k: " + k, null, null);
                this.lang.nextStep();
                this.sc.toggleHighlight(8, 0, false, 9, 0);
                if (w.equals("")) {
                    this.lang.nextStep();
                    this.sc.toggleHighlight(9, 0, false, 10, 0);
                    w = k;
                    wLabel.setText("w: " + w, null, null);
                    this.lang.nextStep();
                    this.sc.toggleHighlight(10, 0, false, 11, 0);
                    this.lang.nextStep();
                    this.sc.toggleHighlight(11, 0, false, 5, 0);
                } else if (!dict.contains(String.valueOf(w) + k)) {
                    this.lang.nextStep();
                    this.sc.toggleHighlight(9, 0, false, 13, 0);
                    this.lang.nextStep();
                    this.sc.toggleHighlight(13, 0, false, 14, 0);
                    result = String.valueOf(result) + w;
                    ausgabe.setText(result, null, null);
                    this.lang.nextStep();
                    this.sc.toggleHighlight(14, 0, false, 15, 0);
                    dict.put(dicCnt, String.valueOf(w) + k);
                    dic.put(matrixCount, 0, "" + (matrixCount + 256), null, null);
                    dic.put(matrixCount, 1, String.valueOf(w) + k, null, null);
                    ++matrixCount;
                    this.lang.nextStep();
                    this.sc.toggleHighlight(15, 0, false, 16, 0);
                    dicLabel.setText("dicCnt: " + ++dicCnt, null, null);
                    this.lang.nextStep();
                    this.sc.toggleHighlight(16, 0, false, 17, 0);
                    w = k;
                    wLabel.setText("w: " + w, null, null);
                    this.lang.nextStep();
                    this.sc.unhighlight(17, 0, false);
                }
            } else {
                this.lang.nextStep();
                this.sc.toggleHighlight(7, 0, false, 20, 0);
                this.lang.nextStep();
                this.sc.toggleHighlight(20, 0, false, 21, 0);
                result = String.valueOf(result) + w;
                ausgabe.setText(result, null, null);
                this.lang.nextStep();
                this.sc.toggleHighlight(21, 0, false, 22, 0);
                String add = (String)dict.get(tmp);
                this.lang.nextStep();
                this.sc.toggleHighlight(22, 0, false, 23, 0);
                dict.put(dicCnt, String.valueOf(w) + add.charAt(0));
                dic.put(matrixCount, 0, "" + (matrixCount + 256), null, null);
                dic.put(matrixCount, 1, String.valueOf(w) + add.charAt(0), null, null);
                ++matrixCount;
                this.lang.nextStep();
                this.sc.toggleHighlight(23, 0, false, 24, 0);
                dicLabel.setText("dicCnt: " + ++dicCnt, null, null);
                this.lang.nextStep();
                this.sc.toggleHighlight(24, 0, false, 25, 0);
                w = add;
                wLabel.setText("w: " + w, null, null);
                this.lang.nextStep();
                this.sc.unhighlight(25, 0, false);
            }
            this.sc.highlight(5, 0, false);
            am.move(++i5, null, null);
            intArray.highlightCell(i5, null, null);
        }
        this.lang.nextStep();
        this.sc.unhighlight(25, 0, false);
        this.sc.unhighlight(5, 0, false);
        this.sc.highlight(28, 0, false);
        result = String.valueOf(result) + k;
        ausgabe.setText(result, null, null);
        Text fazit1 = this.lang.newText(new Offset(0, 90, ausgabeLabel, "SW"), "Die Ausgabe entspricht genau der anf\u2030nglichen Eingabe. Das", "name", null, tpsteps);
        Text fazit2 = this.lang.newText(new Offset(0, 20, fazit1, "SW"), "W\u02c6rterbuch konnte neu generiert werden.", "fazit", null, tpsteps);
    }

    public static String code(String input) {
        String w = "";
        String k = "";
        String result = "";
        int cnt = 256;
        Hashtable<String, Integer> dict = new Hashtable<String, Integer>();
        int i = 0;
        while (i < 256) {
            dict.put("" + (char)i, i);
            ++i;
        }
        i = 0;
        while (i < input.length()) {
            k = "" + input.charAt(i);
            if (dict.containsKey(String.valueOf(w) + k)) {
                w = String.valueOf(w) + k;
            } else {
                result = String.valueOf(result) + dict.get(w) + " ";
                dict.put(String.valueOf(w) + k, cnt);
                ++cnt;
                w = k;
            }
            ++i;
        }
        result = String.valueOf(result) + dict.get(k);
        return result;
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        try {
            this.decode(strArray);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }

    @Override
    public String getName() {
        return "LZW Decoding";
    }
}

