/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.exceptions.LineNotExistsException;
import animalscriptapi.primitives.ArrayMarker;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.StringArray;
import animalscriptapi.primitives.StringMatrix;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.CompressionAlgorithm;
import java.awt.Color;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LZ78Decoding
extends CompressionAlgorithm
implements Generator {
    private static final int inputLimit = 26;
    private static final String DESCRIPTION = "Die LZ78 Dekodierung ist die Umkehrung der gleichnamigen Kodierung. Das W\u02c6rterbuch, welches in der Kodierung entstanden ist, kann dabei wieder generiert werden.";
    private static final String SOURCE_CODE = "Der Algorithmus wird in einer Animation demonstriert. Um die grafische Animation in voller Gr\u02c6\ufb02e darstellen zu k\u02c6nnen, wird die Eingabe auf 26 Buchstaben begrenzt. Es handelt sich hier um einen Dekodierungsalgorithmus. Ihre Eingabe wird zun\u2030chst durch die entsprechende Kodierung kodiert. Erst diese Daten werden dekodiert.";

    public LZ78Decoding() {
        this(new AnimalScript("LZ78 Decoding", "Florian Lindner", 800, 600));
    }

    public LZ78Decoding(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void compress(String[] text) throws LineNotExistsException {
        String ein = "";
        String[] t = new String[Math.min(text.length, 26)];
        int i = 0;
        while (i < t.length) {
            t[i] = text[i];
            ein = String.valueOf(ein) + text[i];
            ++i;
        }
        text = t;
        Text topic = this.lang.newText(new Coordinates(20, 50), "LZ78 Decoding", "Topic", null, tptopic);
        Rect topicRect = this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        String input = "";
        int i2 = 0;
        while (i2 < text.length) {
            input = String.valueOf(input) + text[i2];
            ++i2;
        }
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 40, topic, "SW"), "Die Eingabe ist:  ", "line1", null, tpsteps);
        Text step12 = this.lang.newText(new Offset(10, -5, step1, "SE"), input, "line1", null, tpsteps);
        step12.changeColor(null, Color.RED, null, null);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 30, step1, "SW"), "Durch die LZ78 Kodierung erhalten wir:  ", "line1", null, tpsteps);
        String in = LZ78Decoding.LZ78code(text);
        Text step22 = this.lang.newText(new Offset(10, -5, step2, "SE"), in, "line1", null, tpsteps);
        step12.changeColor(null, Color.BLACK, null, null);
        step22.changeColor(null, Color.RED, null, null);
        Text step3 = this.lang.newText(new Offset(0, 30, step2, "SW"), "Wir wollen die Ausgabe nun wieder dekodieren.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step4 = this.lang.newText(new Offset(10, 40, step3, "SW"), "- Lese die Eingabezahlen einzeln ein. ", "line2", null, tpsteps);
        Text step41 = this.lang.newText(new Offset(0, 20, step4, "SW"), "- Erweitere die Ausgabe um die Buchstaben aus dem W\u02c6rterbuch, die dieser Zahl entsprechen.", "line2", null, tpsteps);
        Text step42 = this.lang.newText(new Offset(0, 20, step41, "SW"), "- F\u00b8ge dem W\u02c6rterbuch an der n\u2030chsten freien Stelle einen neuen Eintrag hinzu, welcher aus", "line2", null, tpsteps);
        Text step43 = this.lang.newText(new Offset(0, 20, step42, "SW"), "  dem zuvor gelesenen Eintrag erweitert um den ersten Buchstaben des eben gelesenen", "line2", null, tpsteps);
        Text step44 = this.lang.newText(new Offset(0, 20, step43, "SW"), "  Teils besteht.", "line2", null, tpsteps);
        this.lang.nextStep();
        step4.hide();
        step41.hide();
        step42.hide();
        step43.hide();
        step44.hide();
        String[][] dictData = new String[30][2];
        int i3 = 0;
        while (i3 < dictData.length) {
            dictData[i3][0] = "  ";
            dictData[i3][1] = "  ";
            ++i3;
        }
        dictData[0][0] = "0";
        dictData[0][1] = "EOF";
        dictData[1][0] = "1";
        dictData[1][1] = "A";
        dictData[2][0] = "...";
        dictData[2][1] = "...";
        dictData[3][0] = "26";
        dictData[3][1] = "Z";
        int matrixCounter = 4;
        StringTokenizer to = new StringTokenizer(in);
        int cnt = to.countTokens();
        String[] eingabeData = new String[cnt];
        int i4 = 0;
        while (i4 < cnt) {
            eingabeData[i4] = to.nextToken();
            ++i4;
        }
        StringArray eingabe = this.lang.newStringArray(new Offset(0, 70, step3, "SW"), eingabeData, "eingabe", null, ap);
        ArrayMarker am = this.lang.newArrayMarker(eingabe, 0, "am", null, amp);
        eingabe.highlightCell(0, null, null);
        StringMatrix dictMatrix = this.lang.newStringMatrix(new Offset(175, 25, step3, "NE"), dictData, "dict", null, mp);
        String result = "";
        Text ausgabeLabel = this.lang.newText(new Offset(0, 70, eingabe, "SW"), "Ausgabe:", "ausgabe", null, tpsteps);
        Text ausgabe = this.lang.newText(new Offset(15, -5, ausgabeLabel, "SE"), result, "ausgabe", null, tpsteps);
        ausgabe.changeColor(null, Color.BLUE, null, null);
        Vector<String> dict = new Vector<String>(0, 1);
        dict.add("EOF");
        int i5 = 65;
        while (i5 < 91) {
            dict.add("" + (char)i5);
            ++i5;
        }
        StringTokenizer t2 = new StringTokenizer(in);
        String last = "";
        int i6 = 0;
        while (i6 < cnt) {
            if (i6 > 0) {
                eingabe.unhighlightCell(i6 - 1, null, null);
                am.move(i6, null, null);
                eingabe.highlightCell(i6, null, null);
            }
            String tmp = t2.nextToken();
            result = String.valueOf(result) + (String)dict.elementAt(Integer.parseInt(tmp));
            this.lang.nextStep();
            ausgabe.setText(result, null, null);
            if (i6 > 0) {
                dict.add(String.valueOf((String)dict.elementAt(Integer.parseInt(last))) + ((String)dict.elementAt(Integer.parseInt(tmp))).charAt(0));
                dictMatrix.put(matrixCounter, 0, "" + (matrixCounter + 23), null, null);
                dictMatrix.put(matrixCounter, 1, String.valueOf((String)dict.elementAt(Integer.parseInt(last))) + ((String)dict.elementAt(Integer.parseInt(tmp))).charAt(0), null, null);
                ++matrixCounter;
                this.lang.nextStep();
            }
            last = tmp;
            ++i6;
        }
        Text fazit = this.lang.newText(new Offset(0, 60, ausgabeLabel, "SW"), "Die Ausgabe entspricht genau der Eingabe.", "Ausgabe", null, tpsteps);
    }

    public static String LZ78code(String[] text) {
        String input = "";
        int i = 0;
        while (i < text.length) {
            input = String.valueOf(input) + text[i];
            ++i;
        }
        input = input.toUpperCase();
        Vector<String> dict = new Vector<String>(0, 1);
        dict.add("EOF");
        int i2 = 65;
        while (i2 < 91) {
            dict.add("" + (char)i2);
            ++i2;
        }
        String result = "";
        int i3 = 0;
        while (i3 < input.length()) {
            String tmp = "" + input.charAt(i3);
            while (dict.contains(tmp) && i3 + 1 < input.length()) {
                if (dict.contains(String.valueOf(tmp) + input.charAt(i3 + 1))) {
                    tmp = String.valueOf(tmp) + input.charAt(i3 + 1);
                    ++i3;
                    continue;
                }
                dict.add(String.valueOf(tmp) + input.charAt(i3 + 1));
                break;
            }
            result = String.valueOf(result) + dict.indexOf(tmp) + " ";
            ++i3;
        }
        return result;
    }

    public static String getSOURCE_CODE() {
        return SOURCE_CODE;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return "LZ78 Decoding";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        try {
            this.compress(strArray);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }
}

