/*
 * Decompiled with CFR 0.152.
 */
package generatorImplementations;

import animalscriptapi.animalscript.AnimalScript;
import animalscriptapi.exceptions.LineNotExistsException;
import animalscriptapi.primitives.Graph;
import animalscriptapi.primitives.Rect;
import animalscriptapi.primitives.StringMatrix;
import animalscriptapi.primitives.Text;
import animalscriptapi.primitives.generators.Language;
import animalscriptapi.util.Coordinates;
import animalscriptapi.util.Node;
import animalscriptapi.util.Offset;
import generator.Generator;
import generator.GeneratorType;
import generator.properties.AnimationPropertiesContainer;
import generatorImplementations.CompressionAlgorithm;
import java.awt.Color;
import java.awt.Font;
import java.util.Hashtable;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Huffman
extends CompressionAlgorithm
implements Generator {
    private static final int inputLimit = 11;
    private static final String DESCRIPTION = "Die Huffman-Kodierung ist \u2030hnlich wie die Shannon-Fano-Kodierung ein entropisches Kodierungsverfahren. So werden bei der Huffman-Kodierung ebenfalls die H\u2030ufigkeiten des Eingabetextes verwendet, um einen bin\u2030ren Baum zu erzeugen.";
    private static final String SOURCE_CODE = "Der Algorithmus wird in einer Animation demonstriert. Um die grafische Animation in voller Gr\u02c6\ufb02e darstellen zu k\u02c6nnen, wird die Eingabe auf 11 Buchstaben begrenzt.";

    public Huffman() {
        this(new AnimalScript("Huffman Kodierung", "Florian Lindner", 800, 600));
    }

    public Huffman(Language l) {
        this.lang = l;
        this.lang.setStepMode(true);
    }

    public void compress(String[] text) throws LineNotExistsException {
        int bigIndex;
        int big;
        String[] t = new String[Math.min(11, text.length)];
        int i = 0;
        while (i < Math.min(11, text.length)) {
            t[i] = text[i];
            ++i;
        }
        text = t;
        Text topic = this.lang.newText(new Coordinates(20, 50), "Huffman Encoding", "Topic", null, tptopic);
        Rect topicRect = this.lang.newRect(new Offset(-5, -5, topic, "NW"), new Offset(5, 5, topic, "SE"), "topicRect", null, rctp);
        this.lang.nextStep();
        Text algoinWords = this.lang.newText(new Coordinates(20, 100), "Der Algorithmus in Worten", "inWords", null, tpwords);
        this.lang.nextStep();
        Text step1 = this.lang.newText(new Offset(0, 100, topic, "SW"), "1) Ermittle die H\u2030ufigkeiten der Buchstaben in der Eingabe.", "line1", null, tpsteps);
        this.lang.nextStep();
        Text step2 = this.lang.newText(new Offset(0, 30, step1, "SW"), "2) Erstelle aus jedem auftretenden Buchstaben einen Knoten mit dessen H\u2030ufigkeit als Blatt eines Baumes.", "line2", null, tpsteps);
        this.lang.nextStep();
        Text step3 = this.lang.newText(new Offset(0, 30, step2, "SW"), "3) Ermittle die zwei Teilb\u2030ume mit der geringsten H\u2030ufigkeit. Verbinde sie durch", "line3", null, tpsteps);
        Text step31 = this.lang.newText(new Offset(0, 20, step3, "SW"), "      einen Baum, bei dem die H\u2030ufigkeit der Summe der H\u2030ufigkeiten der beiden S\u02c6hne", "line31", null, tpsteps);
        Text step32 = this.lang.newText(new Offset(0, 20, step31, "SW"), "      entspricht. Den S\u02c6hnen sei von nun an keine H\u2030ufigkeit mehr zugeordnet.", "line31", null, tpsteps);
        this.lang.nextStep();
        Text step4 = this.lang.newText(new Offset(0, 30, step32, "SW"), "4) Wende Schritt 3 solange an, bis es nur noch einen Wurzelknoten gibt. Die Kanten", "line4", null, tpsteps);
        Text step41 = this.lang.newText(new Offset(0, 20, step4, "SW"), "       nach links zeigend kodieren eine 0, die Rechts-Kanten eine 1. Um einen", "line32", null, tpsteps);
        Text step42 = this.lang.newText(new Offset(0, 20, step41, "SW"), "       Buchstaben zu kodieren ,wird der Weg von der Wurzel zum Blatt verfolgt.", "line32", null, tpsteps);
        this.lang.nextStep();
        algoinWords.hide();
        step1.hide();
        step2.hide();
        step3.hide();
        step31.hide();
        step32.hide();
        step4.hide();
        step41.hide();
        step42.hide();
        tpwords.set("font", new Font("SansSerif", 0, 16));
        String input = "";
        int i2 = 0;
        while (i2 < text.length) {
            input = String.valueOf(input) + text[i2];
            ++i2;
        }
        input = input.toUpperCase();
        algoinWords.setText("Eingabe:  " + input, null, null);
        algoinWords.show();
        this.lang.nextStep();
        step1.changeColor(null, Color.RED, null, null);
        step1.show();
        int[] list = new int[256];
        int i3 = 0;
        while (i3 < text.length) {
            int n = new Integer(text[i3].charAt(0));
            list[n] = list[n] + 1;
            ++i3;
        }
        int numberOfLetters = 0;
        int i4 = 0;
        while (i4 < 256) {
            if (list[i4] != 0) {
                ++numberOfLetters;
            }
            ++i4;
        }
        String[][] freqPrint = new String[numberOfLetters + 1][3];
        freqPrint[0][0] = "char  ";
        freqPrint[0][1] = "freq.  ";
        freqPrint[0][2] = "code  ";
        int[] listClone = (int[])list.clone();
        int cnt = 1;
        int i5 = 0;
        while (i5 < numberOfLetters) {
            freqPrint[cnt][2] = "    ";
            big = -1;
            bigIndex = -1;
            int j = 0;
            while (j < list.length) {
                if (list[j] != 0 && list[j] > big) {
                    big = list[j];
                    bigIndex = j;
                }
                ++j;
            }
            freqPrint[cnt][0] = (char)bigIndex + ":  ";
            freqPrint[cnt][1] = "" + big;
            list[bigIndex] = -1;
            ++cnt;
            ++i5;
        }
        list = listClone;
        StringMatrix strMatrix = this.lang.newStringMatrix(new Offset(115, -20, step2, "NE"), freqPrint, "matrix", null, mp);
        this.lang.nextStep();
        step1.changeColor(null, Color.BLACK, null, null);
        step2.changeColor(null, Color.RED, null, null);
        step3.changeColor(null, Color.RED, null, null);
        step31.changeColor(null, Color.RED, null, null);
        step32.changeColor(null, Color.RED, null, null);
        step4.changeColor(null, Color.RED, null, null);
        step41.changeColor(null, Color.RED, null, null);
        step42.changeColor(null, Color.RED, null, null);
        step2.show();
        this.lang.nextStep();
        TreeSet<NodeH> nodes = new TreeSet<NodeH>();
        int i6 = 0;
        while (i6 < list.length) {
            if (list[i6] > 0) {
                nodes.add(new NodeH((char)i6, list[i6]));
            }
            ++i6;
        }
        TreeSet leaves = (TreeSet)nodes.clone();
        while (nodes.size() > 1) {
            NodeH small = (NodeH)nodes.first();
            nodes.remove(small);
            NodeH small2 = (NodeH)nodes.first();
            nodes.remove(small2);
            nodes.add(new NodeH(small, small2));
        }
        NodeH root = (NodeH)nodes.first();
        Vector<NodeH> order = root.getInOrder();
        int[][] adj = new int[root.elements()][root.elements()];
        int i7 = 0;
        while (i7 < order.size()) {
            if (order.elementAt((int)i7).left != null && order.elementAt((int)i7).right != null) {
                adj[i7][root.getOrderNr((NodeH)order.elementAt((int)i7).left)] = 9;
                adj[i7][root.getOrderNr((NodeH)order.elementAt((int)i7).right)] = 1;
            }
            ++i7;
        }
        Node[] graphNodes = new Node[order.size()];
        graphNodes = root.getCoords(root, new Coordinates(350, 400), graphNodes);
        graphNodes[0] = new Coordinates(350, 250);
        String[] label = new String[order.size()];
        int i8 = 0;
        while (i8 < order.size()) {
            label[i8] = order.elementAt((int)i8).left == null && order.elementAt((int)i8).right == null ? "" + order.elementAt((int)i8).letter : "";
            ++i8;
        }
        Graph gr = this.lang.newGraph("graph", adj, graphNodes, label, null, gp);
        tpsteps.set("font", new Font("SansSerif", 0, 10));
        int i9 = 0;
        while (i9 < order.size()) {
            if (order.elementAt((int)i9).left != null || order.elementAt((int)i9).right != null) {
                gr.hideNode(i9, null, null);
            }
            ++i9;
        }
        this.lang.nextStep();
        step2.changeColor(null, Color.BLACK, null, null);
        step3.changeColor(null, Color.RED, null, null);
        step31.changeColor(null, Color.RED, null, null);
        step32.changeColor(null, Color.RED, null, null);
        step4.changeColor(null, Color.RED, null, null);
        step41.changeColor(null, Color.RED, null, null);
        step42.changeColor(null, Color.RED, null, null);
        step3.show();
        step31.show();
        step32.show();
        step4.show();
        step41.show();
        step42.show();
        this.lang.nextStep();
        step1.hide();
        step2.hide();
        step3.hide();
        step31.hide();
        step32.hide();
        step4.hide();
        step41.hide();
        step42.hide();
        this.lang.nextStep();
        while (leaves.size() > 1) {
            NodeH smallest = (NodeH)leaves.first();
            NodeH father = smallest.getFather(root);
            gr.showNode(root.getOrderNr(father), null, null);
            Text labelRelation = this.lang.newText(gr.getNode(root.getOrderNr(father)), "" + father.getSum(), "label", null, tpsteps);
            labelRelation.changeColor(null, Color.RED, null, null);
            gr.hideEdgeWeight(root.getOrderNr(father), root.getOrderNr(father.left), null, null);
            gr.hideEdgeWeight(root.getOrderNr(father), root.getOrderNr(father.right), null, null);
            leaves.remove(smallest);
            NodeH smallest2 = (NodeH)leaves.first();
            leaves.remove(smallest2);
            leaves.add(father);
            this.lang.nextStep();
        }
        tpsteps.set("font", new Font("SansSerif", 0, 16));
        Text expl = this.lang.newText(new Offset(-150, 45, gr, "SW"), "Um die Kodierung f\u00b8r jeden Buchstaben zu bestimmen, traversiere", "expl", null, tpsteps);
        Text expl2 = this.lang.newText(new Offset(0, 20, expl, "SW"), "den Baum nach obigem Bitmuster.", "expl", null, tpsteps);
        this.lang.nextStep();
        int i10 = 0;
        while (i10 < gr.getSize()) {
            gr.showEdgeWeight(i10, i10, null, null);
            ++i10;
        }
        this.lang.nextStep();
        big = 0;
        cnt = 1;
        bigIndex = -1;
        i10 = 0;
        while (i10 < numberOfLetters) {
            big = -1;
            int j = 0;
            while (j < list.length) {
                if (list[j] > big) {
                    big = list[j];
                    bigIndex = j;
                }
                ++j;
            }
            strMatrix.put(cnt, 2, ((NodeH)nodes.first()).getBits((char)bigIndex), null, null);
            strMatrix.highlightCell(cnt, 2, null, null);
            Vector<Integer> nedgeNodes = root.getEdgeNodes((char)bigIndex);
            int k = 0;
            while (k < nedgeNodes.size() - 1) {
                gr.highlightEdge(nedgeNodes.elementAt(k), nedgeNodes.elementAt(k + 1), null, null);
                ++k;
            }
            list[bigIndex] = -1;
            this.lang.nextStep();
            strMatrix.unhighlightCell(++cnt - 1, 2, null, null);
            int l = 0;
            while (l < gr.getSize() - 1) {
                gr.unhighlightEdge(l, l + 1, null, null);
                ++l;
            }
            ++i10;
        }
        String result = "";
        int i11 = 0;
        while (i11 < input.length()) {
            result = String.valueOf(result) + ((NodeH)nodes.first()).getBits(input.charAt(i11));
            result = String.valueOf(result) + " ";
            ++i11;
        }
        Text fazit = this.lang.newText(new Offset(0, 40, expl2, "SW"), "Durch die bitweise Traversierung des Baumes k\u02c6nnen wir nun jeden", "Ausgabe", null, tpsteps);
        Text fazit2 = this.lang.newText(new Offset(0, 20, fazit, "SW"), "Buchstaben der Eingabe einzeln kodieren. Dadurch erhalten wir:", "ausgabe", null, tpsteps);
        Text fazit3 = this.lang.newText(new Offset(0, 20, fazit2, "SW"), result, "fazit", null, tpsteps);
        fazit3.changeColor(null, Color.BLUE, null, null);
    }

    public static String getSOURCE_CODE() {
        return SOURCE_CODE;
    }

    @Override
    public String getCodeExample() {
        return SOURCE_CODE;
    }

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public String getName() {
        return "Huffman Encoding";
    }

    @Override
    public String generate(AnimationPropertiesContainer props, Hashtable<String, Object> primitives) {
        String[] strArray = (String[])primitives.get("stringArray");
        try {
            this.compress(strArray);
        }
        catch (LineNotExistsException e) {
            e.printStackTrace();
        }
        this.lang.finalizeGeneration();
        return this.lang.getAnimationCode();
    }

    @Override
    public String getFileExtension() {
        return "asu";
    }

    @Override
    public GeneratorType getGeneratorType() {
        return new GeneratorType(64);
    }

    @Override
    public String getAlgorithmName() {
        return "Huffman";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeH
    implements Comparable {
        int sum;
        char letter;
        public NodeH left;
        public NodeH right;

        public NodeH(char letterIn, int sumIn) {
            this.letter = letterIn;
            this.sum = sumIn;
        }

        public NodeH(NodeH leftIn, NodeH rightIn) {
            this.letter = leftIn.letter < rightIn.letter ? leftIn.letter : rightIn.letter;
            this.sum = leftIn.sum + rightIn.sum;
            this.left = leftIn;
            this.right = rightIn;
        }

        public String getBits(char letterIn) {
            if (this.letter == letterIn && this.left == null && this.right == null) {
                return "";
            }
            if (this.left == null && this.right == null) {
                return null;
            }
            if (this.left.getBits(letterIn) != null) {
                return "0" + this.left.getBits(letterIn);
            }
            if (this.right.getBits(letterIn) != null) {
                return "1" + this.right.getBits(letterIn);
            }
            return null;
        }

        public int compareTo(Object o) {
            if (this.sum < ((NodeH)o).sum) {
                return -1;
            }
            if (this.sum > ((NodeH)o).sum) {
                return 1;
            }
            if (this.getLetter() < ((NodeH)o).getLetter()) {
                return -1;
            }
            if (this.getLetter() > ((NodeH)o).getLetter()) {
                return 1;
            }
            return 0;
        }

        public int getHeight() {
            if (this.getRight() == null && this.getLeft() == null) {
                return 0;
            }
            return 1 + Math.max(this.left.getHeight(), this.right.getHeight());
        }

        public int elements() {
            if (this.getRight() == null && this.getLeft() == null) {
                return 1;
            }
            return 1 + this.left.elements() + this.right.elements();
        }

        public Vector<NodeH> getInOrder() {
            Vector<NodeH> order = new Vector<NodeH>(0, 1);
            return this.getInOrder(order);
        }

        public Vector<NodeH> getInOrder(Vector<NodeH> order) {
            order.add(this);
            if (this.getLeft() != null) {
                order = this.getLeft().getInOrder(order);
            }
            if (this.getRight() != null) {
                order = this.getRight().getInOrder(order);
            }
            return order;
        }

        public int getOrderNr(NodeH p) {
            Vector<NodeH> order = this.getInOrder();
            int i = 0;
            while (i < order.size()) {
                if (p.equals(order.elementAt(i))) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public Vector<Integer> getEdgeNodes(char letter) {
            Vector<NodeH> nodesOrdered = this.getInOrder();
            Vector<Integer> nodes = new Vector<Integer>();
            int i = 0;
            while (i < nodesOrdered.size()) {
                if (nodesOrdered.elementAt(i).getLetter() == letter && nodesOrdered.elementAt(i).getLeft() == null && nodesOrdered.elementAt(i).getRight() == null) {
                    nodes.add(this.getOrderNr(nodesOrdered.elementAt(i)));
                    NodeH tmp = nodesOrdered.elementAt(i);
                    while (tmp.getFather(this) != null) {
                        nodes.add(this.getOrderNr(tmp.getFather(this)));
                        tmp = tmp.getFather(this);
                    }
                    break;
                }
                ++i;
            }
            return nodes;
        }

        public static int getDistance(NodeH upper, NodeH lower) {
            if (upper.equals(lower)) {
                return 0;
            }
            if (upper.getLeft() == null && upper.getRight() == null) {
                return 1000;
            }
            return Math.min(1 + NodeH.getDistance(upper.left, lower), 1 + NodeH.getDistance(upper.right, lower));
        }

        public Node[] getCoords(NodeH main, Node actualCoords, Node[] coords) {
            int h = main.getHeight();
            float offsetFactor = (float)Math.pow(2.0, 1 - NodeH.getDistance(main, this));
            float l = 700.0f / (float)(Math.pow(2.0, h) - 1.0);
            if (this.getLeft() != null || this.getRight() != null) {
                int x = ((Coordinates)actualCoords).getX() - new Float(l * offsetFactor).intValue();
                int y = ((Coordinates)actualCoords).getY() + 50;
                int nrLeft = main.getOrderNr(this.left);
                coords[nrLeft] = new Coordinates(x, y);
                x = ((Coordinates)actualCoords).getX() + new Float(l * offsetFactor).intValue();
                int nrRight = main.getOrderNr(this.right);
                coords[nrRight] = new Coordinates(x, y);
                coords = this.left.getCoords(main, coords[nrLeft], coords);
                coords = this.right.getCoords(main, coords[nrRight], coords);
            }
            return coords;
        }

        public NodeH getFather(NodeH p) {
            Vector<NodeH> nodes = p.getInOrder();
            int i = 0;
            while (i < nodes.size()) {
                if (nodes.elementAt((int)i).left != null && nodes.elementAt((int)i).left.equals(this)) {
                    return nodes.elementAt(i);
                }
                if (nodes.elementAt((int)i).right != null && nodes.elementAt((int)i).right.equals(this)) {
                    return nodes.elementAt(i);
                }
                ++i;
            }
            return null;
        }

        public NodeH getLeft() {
            return this.left;
        }

        public char getLetter() {
            return this.letter;
        }

        public NodeH getRight() {
            return this.right;
        }

        public int getSum() {
            return this.sum;
        }
    }
}

