/*
 * Decompiled with CFR 0.152.
 */
package generator.properties.tree;

import generator.properties.tree.PropertiesTreeModel;
import generator.properties.tree.PropertiesTreeNode;
import generator.properties.tree.PropertiesTreeRenderer;
import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PropertiesTree
extends JTree {
    private static final long serialVersionUID = 4048795649896298288L;
    private PropertiesTreeModel model = (PropertiesTreeModel)this.getModel();
    boolean treeDraggingAllowed = true;
    boolean _treeDragging = false;
    private PropertiesTreeNode _treeDraggingNode = null;

    public PropertiesTree() {
        super(new PropertiesTreeModel());
        this.setRootVisible(true);
        this.setShowsRootHandles(true);
        this.setEditable(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new PropertiesTreeRenderer());
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                if (!PropertiesTree.this.treeDraggingAllowed) {
                    return;
                }
                if (!PropertiesTree.this._treeDragging) {
                    PropertiesTree.this._treeDragging = true;
                    TreePath path = PropertiesTree.this.getPathForLocation(e.getX(), e.getY());
                    PropertiesTreeNode node = null;
                    if (path != null && path.getLastPathComponent() instanceof PropertiesTreeNode) {
                        node = (PropertiesTreeNode)path.getLastPathComponent();
                    }
                    if (node != null && node != path.getPathComponent(0)) {
                        PropertiesTree.this.setCursor(new Cursor(12));
                    }
                    PropertiesTree.this.mouseDragOnTree(e, node);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (!PropertiesTree.this.treeDraggingAllowed) {
                    return;
                }
                if (PropertiesTree.this._treeDragging) {
                    TreePath path = PropertiesTree.this.getPathForLocation(e.getX(), e.getY());
                    PropertiesTree.this._treeDragging = false;
                    PropertiesTree.this.setCursor(new Cursor(0));
                    PropertiesTreeNode node = null;
                    if (path != null && path.getLastPathComponent() instanceof PropertiesTreeNode) {
                        node = (PropertiesTreeNode)path.getLastPathComponent();
                    }
                    PropertiesTree.this.mouseDropOnTree(e, node);
                }
            }
        });
        this.expandAllFolders();
    }

    protected void mouseDragOnTree(MouseEvent e, PropertiesTreeNode node) {
        if (node == null || e == null || node == this.model.getRoot()) {
            return;
        }
        this._treeDraggingNode = node;
    }

    protected void mouseDropOnTree(MouseEvent e, PropertiesTreeNode target) {
        if (target == null || e == null || this._treeDraggingNode == null) {
            return;
        }
        if (target.getAnimationProperties() != null && !target.isFolder()) {
            this.mouseDropOnTree(e, (PropertiesTreeNode)target.getParent());
            return;
        }
        if (this._treeDraggingNode == target) {
            return;
        }
        PropertiesTreeNode draggingTreeNodeParent = (PropertiesTreeNode)this._treeDraggingNode.getParent();
        if (draggingTreeNodeParent != null) {
            this.model.removeNodeFromParent(this._treeDraggingNode);
            PropertiesTreeNode prevAncestor = null;
            PropertiesTreeNode ancestor = target;
            boolean found = false;
            do {
                if (ancestor == this._treeDraggingNode) {
                    found = true;
                    break;
                }
                prevAncestor = ancestor;
            } while ((ancestor = (PropertiesTreeNode)ancestor.getParent()) != null);
            if (found && prevAncestor != null) {
                this.model.insertNodeInto(prevAncestor, draggingTreeNodeParent, 0);
            }
            this.model.insertNodeInto(this._treeDraggingNode, target, 0);
            this.expandAllFolders();
            this.setSelectionRow(0);
            this._treeDraggingNode = null;
        }
    }

    public void expandAllFolders() {
        Enumeration<TreeNode> e = ((PropertiesTreeNode)this.getModel().getRoot()).depthFirstEnumeration();
        while (e.hasMoreElements()) {
            TreePath t = new TreePath(((PropertiesTreeNode)e.nextElement()).getPath());
            PropertiesTreeNode n = (PropertiesTreeNode)t.getLastPathComponent();
            if (n.isItem() || n.isPrimitive() || n.isFolder()) {
                this.setExpandedState(t, true);
                continue;
            }
            this.setExpandedState(t, !this.model.getShowItems());
        }
    }

    protected void setExpandedState(TreePath path, boolean state) {
        if (path == null) {
            return;
        }
        if (path.getPathCount() < 2) {
            super.setExpandedState(path, true);
        } else {
            super.setExpandedState(path, state);
        }
    }

    public boolean getDraggingAllowed() {
        return this.treeDraggingAllowed;
    }

    public void setDraggingAllowed(boolean b) {
        this.treeDraggingAllowed = b;
    }

    public void setBuildMode() {
        this.treeDraggingAllowed = true;
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.model.setShowItems(false);
        this.model.setShowHiddenItems(false);
    }

    public void setWorkingMode() {
        this.treeDraggingAllowed = false;
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.model.setShowItems(true);
        this.model.setShowHiddenItems(true);
    }

    public void setFinalMode() {
        this.treeDraggingAllowed = false;
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.model.setShowItems(true);
        this.model.setShowHiddenItems(false);
    }
}

