/*
 * Decompiled with CFR 0.152.
 */
package generator.properties;

import animalscriptapi.properties.AnimationProperties;
import animalscriptapi.properties.Visitor;
import animalscriptapi.properties.items.AnimationPropertyItem;
import animalscriptapi.properties.items.BooleanPropertyItem;
import animalscriptapi.properties.items.ColorPropertyItem;
import animalscriptapi.properties.items.DoublePropertyItem;
import animalscriptapi.properties.items.FontPropertyItem;
import animalscriptapi.properties.items.IntegerPropertyItem;
import animalscriptapi.properties.items.StringPropertyItem;
import java.awt.Color;
import java.awt.Font;
import java.util.Vector;

public class GetAsXMLVisitor
implements Visitor {
    private StringBuilder buffer;

    public String getPropertiesAsXML(AnimationProperties ap, int l) {
        int i;
        StringBuilder bigBuffer = new StringBuilder(1024);
        int i2 = 0;
        while (i2 < l) {
            bigBuffer.append("\t");
            ++i2;
        }
        bigBuffer.append("<AnimationProperties type=\"");
        bigBuffer.append(GetAsXMLVisitor.replaceEntitiesForXML(GetAsXMLVisitor.getSimpleName(ap.getClass().getName())));
        bigBuffer.append("\">\n");
        Vector<String> items = ap.getAllPropertyNamesVector();
        for (String itemName : items) {
            AnimationPropertyItem item = ap.getItem(itemName);
            i = 0;
            while (i < l) {
                bigBuffer.append("\t");
                ++i;
            }
            bigBuffer.append("\t<AnimationPropertyItem type=\"");
            bigBuffer.append(GetAsXMLVisitor.replaceEntitiesForXML(GetAsXMLVisitor.getSimpleName(item.getClass().getName())));
            bigBuffer.append("\">\n");
            i = 0;
            while (i < l) {
                bigBuffer.append("\t");
                ++i;
            }
            bigBuffer.append("\t\t<name>");
            bigBuffer.append(GetAsXMLVisitor.replaceEntitiesForXML(itemName));
            bigBuffer.append("</name>\n");
            i = 0;
            while (i < l) {
                bigBuffer.append("\t");
                ++i;
            }
            bigBuffer.append("\t\t<isEditable value=");
            if (ap.getIsEditable(itemName)) {
                bigBuffer.append("\"true\" />\n");
            } else {
                bigBuffer.append("\"false\" />\n");
            }
            i = 0;
            while (i < l) {
                bigBuffer.append("\t");
                ++i;
            }
            bigBuffer.append("\t\t<label>");
            bigBuffer.append(GetAsXMLVisitor.replaceEntitiesForXML(ap.getLabel(itemName)));
            bigBuffer.append("</label>\n");
            i = 0;
            while (i < l) {
                bigBuffer.append("\t");
                ++i;
            }
            bigBuffer.append("\t\t<value>");
            item.accept(this);
            bigBuffer.append(this.buffer.toString());
            bigBuffer.append("</value>\n");
            i = 0;
            while (i < l) {
                bigBuffer.append("\t");
                ++i;
            }
            bigBuffer.append("\t</AnimationPropertyItem>\n");
        }
        i = 0;
        while (i < l) {
            bigBuffer.append("\t");
            ++i;
        }
        bigBuffer.append("</AnimationProperties>\n");
        return bigBuffer.toString();
    }

    public String getPrimitiveAsXML(String name, Object value, int l) {
        StringBuilder buf = new StringBuilder(256);
        int i = 0;
        while (i < l) {
            buf.append("\t");
            ++i;
        }
        buf.append("<Primitive type=\"");
        buf.append(GetAsXMLVisitor.getPrimitiveTypeAsString(value));
        buf.append("\">\n");
        i = 0;
        while (i < l) {
            buf.append("\t");
            ++i;
        }
        buf.append("\t<name>");
        buf.append(GetAsXMLVisitor.replaceEntitiesForXML(name));
        buf.append("</name>\n");
        i = 0;
        while (i < l) {
            buf.append("\t");
            ++i;
        }
        buf.append("\t<value>");
        buf.append(GetAsXMLVisitor.getPrimitiveValueAsString(value));
        buf.append("</value>\n");
        i = 0;
        while (i < l) {
            buf.append("\t");
            ++i;
        }
        buf.append("</Primitive>\n");
        return buf.toString();
    }

    private static String getPrimitiveTypeAsString(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("null cannot be a Primitive!");
        }
        if (value instanceof String) {
            return "String";
        }
        if (value instanceof Integer) {
            return "int";
        }
        if (value instanceof Boolean) {
            return "boolean";
        }
        if (value instanceof Double) {
            return "double";
        }
        if (value instanceof int[]) {
            return "intArray";
        }
        if (value instanceof String[]) {
            return "StringArray";
        }
        if (value instanceof Color) {
            return "Color";
        }
        if (value instanceof Font) {
            return "Font";
        }
        throw new IllegalArgumentException("Unknown Primitive Type!");
    }

    private static String getPrimitiveValueAsString(Object value) {
        if (value == null) {
            throw new IllegalArgumentException("null cannot be a Primitive!");
        }
        if (value instanceof String) {
            return GetAsXMLVisitor.getStringAsXML((String)value);
        }
        if (value instanceof Integer) {
            return GetAsXMLVisitor.getIntegerAsXML((Integer)value);
        }
        if (value instanceof Boolean) {
            return GetAsXMLVisitor.getBooleanAsXML((Boolean)value);
        }
        if (value instanceof Double) {
            return GetAsXMLVisitor.getDoubleAsXML((Double)value);
        }
        if (value instanceof int[]) {
            return GetAsXMLVisitor.getIntArrayAsXML((int[])value);
        }
        if (value instanceof String[]) {
            return GetAsXMLVisitor.getStringArrayAsXML((String[])value);
        }
        if (value instanceof Color) {
            return GetAsXMLVisitor.getColorAsXML((Color)value);
        }
        if (value instanceof Font) {
            return GetAsXMLVisitor.getFontAsXML((Font)value);
        }
        throw new IllegalArgumentException("Unknown Primitive Type!");
    }

    public void visit(StringPropertyItem spi) {
        this.buffer = new StringBuilder(GetAsXMLVisitor.getStringAsXML((String)spi.get()));
    }

    public void visit(IntegerPropertyItem ipi) {
        this.buffer = new StringBuilder(GetAsXMLVisitor.getIntegerAsXML((Integer)ipi.get()));
    }

    public void visit(BooleanPropertyItem bpi) {
        this.buffer = new StringBuilder(GetAsXMLVisitor.getBooleanAsXML((Boolean)bpi.get()));
    }

    public void visit(DoublePropertyItem dpi) {
        this.buffer = new StringBuilder(GetAsXMLVisitor.getDoubleAsXML((Double)dpi.get()));
    }

    public void visit(ColorPropertyItem cpi) {
        this.buffer = new StringBuilder(GetAsXMLVisitor.getColorAsXML((Color)cpi.get()));
    }

    public void visit(FontPropertyItem fpi) {
        this.buffer = new StringBuilder(GetAsXMLVisitor.getFontAsXML((Font)fpi.get()));
    }

    private static String getStringAsXML(String str) {
        StringBuilder buf = new StringBuilder(23);
        buf.append("<String>");
        buf.append(GetAsXMLVisitor.replaceEntitiesForXML(str));
        buf.append("</String>");
        return buf.toString();
    }

    private static String getIntegerAsXML(Integer i) {
        StringBuilder buf = new StringBuilder(23);
        buf.append("<int>");
        buf.append(i.toString());
        buf.append("</int>");
        return buf.toString();
    }

    private static String getBooleanAsXML(Boolean b) {
        StringBuilder buf = new StringBuilder(23);
        buf.append("<boolean value=\"");
        buf.append(b.toString());
        buf.append("\" />");
        return buf.toString();
    }

    private static String getDoubleAsXML(Double d) {
        StringBuilder buf = new StringBuilder(23);
        buf.append("<double>");
        buf.append(d.toString());
        buf.append("</double>");
        return buf.toString();
    }

    private static String getIntArrayAsXML(int[] intArray) {
        if (intArray == null || intArray.length < 1) {
            throw new IllegalArgumentException("intArrays cannot be empty!");
        }
        StringBuilder buf = new StringBuilder(23);
        buf.append("<intArray>");
        int i = 0;
        while (i < intArray.length - 1) {
            buf.append(intArray[i]);
            buf.append(", ");
            ++i;
        }
        buf.append(intArray[intArray.length - 1]);
        buf.append("</intArray>");
        return buf.toString();
    }

    private static String getStringArrayAsXML(String[] stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            throw new IllegalArgumentException("StringArrays cannot be empty!");
        }
        StringBuilder buf = new StringBuilder(23);
        buf.append("<StringArray>");
        int i = 0;
        while (i < stringArray.length - 1) {
            buf.append(stringArray[i]);
            buf.append(", ");
            ++i;
        }
        buf.append(stringArray[stringArray.length - 1]);
        buf.append("</StringArray>");
        return buf.toString();
    }

    private static String getColorAsXML(Color c) {
        StringBuilder buf = new StringBuilder(29);
        buf.append("<Color>(");
        buf.append(Integer.toString(c.getRed()));
        buf.append(", ");
        buf.append(Integer.toString(c.getGreen()));
        buf.append(", ");
        buf.append(Integer.toString(c.getBlue()));
        buf.append(")</Color>");
        return buf.toString();
    }

    private static String getFontAsXML(Font f) {
        StringBuilder buf = new StringBuilder(23);
        buf.append("<Font>");
        buf.append(f.getFamily());
        buf.append("</Font>");
        return buf.toString();
    }

    public static String replaceEntitiesForXML(String str) {
        String ret = new String(str);
        ret = ret.replaceAll("&", "&amp;");
        ret = ret.replaceAll("<", "&lt;");
        ret = ret.replaceAll(">", "&gt;");
        ret = ret.replaceAll("'", "&apos;");
        ret = ret.replaceAll("\"", "&quot;");
        return ret;
    }

    public static String getSimpleName(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        int from = str.lastIndexOf(".");
        if (from == -1) {
            return str;
        }
        return str.substring(from + 1);
    }

    public String getXMLString() {
        return this.buffer.toString();
    }
}

