/*
 * Decompiled with CFR 0.152.
 */
package generator;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class NewPrimitiveDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 3689910665234233655L;
    private JComboBox cmbTypes;
    private JTextField txtName;
    private String type;
    private String name;
    private boolean returnValue;

    public NewPrimitiveDialog(JFrame parent) {
        super(parent, "New Primitive", true);
        JPanel border = new JPanel();
        border.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().setLayout(new BorderLayout(8, 8));
        this.getContentPane().add((Component)border, "Center");
        String[] primitives = new String[]{"String", "int", "boolean", "double", "int[]", "String[]", "Color", "Font"};
        this.cmbTypes = new JComboBox<String>(primitives);
        this.cmbTypes.setPreferredSize(new Dimension(250, this.cmbTypes.getMinimumSize().height));
        this.cmbTypes.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.cmbTypes.getMinimumSize().height));
        this.cmbTypes.setAlignmentX(0.0f);
        this.cmbTypes.setActionCommand("cmbTypes");
        this.cmbTypes.addActionListener(this);
        this.txtName = new JTextField("");
        this.name = "";
        this.txtName.setPreferredSize(new Dimension(250, this.txtName.getMinimumSize().height));
        this.txtName.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.txtName.getMinimumSize().height));
        this.txtName.setAlignmentX(0.0f);
        border.setLayout(new BoxLayout(border, 3));
        JLabel lblType = new JLabel("Chose a Primitive Type:");
        border.add(lblType);
        border.add(Box.createRigidArea(new Dimension(0, 4)));
        border.add(this.cmbTypes);
        border.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel lblName = new JLabel("Enter a Name:");
        border.add(lblName);
        border.add(Box.createRigidArea(new Dimension(0, 4)));
        border.add(this.txtName);
        border.add(Box.createRigidArea(new Dimension(0, 16)));
        JPanel pBut = new JPanel();
        pBut.setLayout(new BoxLayout(pBut, 2));
        pBut.setAlignmentX(0.0f);
        pBut.add(Box.createHorizontalGlue());
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setActionCommand("cancel");
        btnCancel.addActionListener(this);
        pBut.add(btnCancel);
        pBut.add(Box.createRigidArea(new Dimension(8, 0)));
        JButton btnOK = new JButton("OK");
        btnOK.setActionCommand("ok");
        btnOK.addActionListener(this);
        pBut.add(btnOK);
        border.add((Component)pBut, "South");
        this.getRootPane().setDefaultButton(btnOK);
        this.txtName.requestFocus();
        this.pack();
    }

    public boolean showDialog() {
        if (this.cmbTypes.getItemCount() > 0) {
            this.cmbTypes.setSelectedIndex(0);
        }
        this.returnValue = false;
        this.setVisible(true);
        return this.returnValue;
    }

    private static String createNameForPrimitive(String type) {
        if (type == null) {
            return "primitive";
        }
        if (type.endsWith("[]")) {
            type = String.valueOf(type.substring(0, type.length() - 2)) + "Array";
        }
        if (type.length() > 0) {
            type = String.valueOf(type.toLowerCase().charAt(0)) + type.substring(1);
        }
        return type;
    }

    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        if (e.getActionCommand().equalsIgnoreCase("cmbTypes")) {
            JComboBox cb = (JComboBox)e.getSource();
            this.type = (String)cb.getSelectedItem();
            String newName = NewPrimitiveDialog.createNameForPrimitive(this.type);
            this.txtName.setText(newName);
        }
        if (e.getActionCommand().equalsIgnoreCase("ok")) {
            this.returnValue = true;
            this.name = this.txtName.getText();
            this.setVisible(false);
        }
        if (e.getActionCommand().equalsIgnoreCase("cancel")) {
            this.returnValue = false;
            this.setVisible(false);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }
}

