/*
 * Decompiled with CFR 0.152.
 */
package generator;

import animal.misc.MessageDisplay;
import generator.CustomFileFilter;
import generator.Generator;
import generator.GeneratorGUI;
import generator.GeneratorPropertiesEditor;
import generator.GeneratorTreeNode;
import generator.PropertiesPanel;
import generator.properties.tree.PropertiesTreeModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipInputStream;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import translator.AnimalTranslator;
import translator.Translator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorDemo
implements TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    private JFrame myFrame = null;
    private Class<?> generatorDummy;
    JButton quitButton;
    JButton confirmButton;
    private HashMap<String, DefaultMutableTreeNode> generators = new HashMap(101);
    private static Translator trans = new Translator("generator", Locale.US);
    private GeneratorPropertiesEditor editor = null;
    JTree myTree;
    DefaultMutableTreeNode root;
    DefaultMutableTreeNode child;
    private Generator currentGenerator;
    public static final String MAIN_PANEL = "Main";
    public static final String PROPS_PANEL = "Properties";
    public static final String FILE_CHOICE_PANEL = "File Choice";
    private JEditorPane editorPane = null;
    private String activeCard = "Main";
    private JTextField txtFileName = new JTextField();
    private JPanel mainContentPanel;

    public static void main(String[] av) {
        new GeneratorDemo();
    }

    public GeneratorDemo() {
        this.myFrame = new JFrame("JTreeDemo");
        Container cp = this.myFrame.getContentPane();
        cp.setLayout(new BorderLayout());
        this.init();
        this.setupGUI();
    }

    private void init() {
        Vector<String> vector = this.readListOfGenerators();
        this.root = this.addCategory("Generators", "/", null);
        this.myTree = new JTree(this.root);
        for (String genName : vector) {
            Generator gen = GeneratorGUI.createGeneratorByName(genName);
            if (gen == null) continue;
            int generatorType = gen.getGeneratorType().getType();
            String plUsed = gen.getOutputLanguage();
            String languageCode = gen.getContentLocale().getLanguage();
            String algoBaseName = gen.getAlgorithmName();
            StringBuilder genPath = new StringBuilder(64);
            genPath.append(languageCode).append('/').append(plUsed).append('/');
            genPath.append(trans.translateMessage(String.valueOf(generatorType)));
            genPath.append('/').append(algoBaseName);
            DefaultMutableTreeNode parent = this.findOrCreatePath(languageCode, plUsed, trans.translateMessage(String.valueOf(generatorType)), algoBaseName);
            this.addGenerator(gen, genPath.toString(), parent);
        }
    }

    private DefaultMutableTreeNode findOrCreatePath(String ... pathInfo) {
        DefaultMutableTreeNode current = this.generators.get("/");
        DefaultMutableTreeNode lookup = null;
        StringBuilder sb = new StringBuilder(128);
        String[] stringArray = pathInfo;
        int n = 0;
        int n2 = stringArray.length;
        while (n < n2) {
            String s = stringArray[n];
            sb.append('/').append(s);
            lookup = this.generators.get(sb.toString());
            if (lookup == null) {
                lookup = this.addCategory(s, sb.toString(), current);
            }
            current = lookup;
            ++n;
        }
        return current;
    }

    public void setupGUI() {
        this.myTree.addTreeSelectionListener(this);
        Container cp = this.myFrame.getContentPane();
        JSplitPane mainPanel = this.getMainPanel();
        PropertiesPanel propsPanel = this.getPropertiesPanel();
        JPanel fileChoicePanel = this.getFileChoicePanel();
        this.mainContentPanel = new JPanel(new CardLayout());
        this.mainContentPanel.add((Component)mainPanel, MAIN_PANEL);
        this.mainContentPanel.add((Component)propsPanel, PROPS_PANEL);
        this.mainContentPanel.add((Component)fileChoicePanel, FILE_CHOICE_PANEL);
        cp.add((Component)this.mainContentPanel, "Center");
        JPanel buttonPanel = new JPanel();
        this.confirmButton = new JButton("Confirm");
        buttonPanel.add("South", this.confirmButton);
        this.confirmButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (GeneratorDemo.this.activeCard == GeneratorDemo.MAIN_PANEL) {
                    ((CardLayout)GeneratorDemo.this.mainContentPanel.getLayout()).show(GeneratorDemo.this.mainContentPanel, GeneratorDemo.PROPS_PANEL);
                    GeneratorDemo.this.updatePropertiesPanel();
                    JTree aNewTree = new JTree();
                    PropertiesTreeModel ptm = new PropertiesTreeModel();
                    aNewTree.setModel(ptm);
                    if (GeneratorDemo.this.currentGenerator != null) {
                        StringBuilder buf = new StringBuilder(64);
                        buf.append(GeneratorDemo.this.currentGenerator.getClass().getPackage().getName());
                        buf.append("/");
                        buf.append(GeneratorDemo.this.currentGenerator.getClass().getSimpleName());
                        try {
                            ptm.loadFromXMLFile(String.valueOf(buf.toString()) + ".xml", true);
                        }
                        catch (Exception e2) {
                            try {
                                ptm.loadFromXMLFile(String.valueOf(buf.toString()) + ".ptm", true);
                            }
                            catch (Exception e3) {
                                System.err.println(e3.getMessage());
                            }
                            System.err.println(e2.getMessage());
                        }
                    }
                    System.err.println(aNewTree.toString());
                    GeneratorDemo.this.activeCard = GeneratorDemo.PROPS_PANEL;
                } else if (GeneratorDemo.this.activeCard == GeneratorDemo.PROPS_PANEL) {
                    ((CardLayout)GeneratorDemo.this.mainContentPanel.getLayout()).show(GeneratorDemo.this.mainContentPanel, GeneratorDemo.FILE_CHOICE_PANEL);
                }
            }
        });
        this.quitButton = new JButton("Quit");
        buttonPanel.add(this.quitButton);
        this.quitButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneratorDemo.this.myFrame.setVisible(false);
                GeneratorDemo.this.myFrame.dispose();
            }
        });
        this.confirmButton.setEnabled(false);
        cp.add("South", buttonPanel);
        this.myFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                GeneratorDemo.this.myFrame.setVisible(false);
                GeneratorDemo.this.myFrame.dispose();
                System.exit(0);
            }
        });
        this.myFrame.pack();
        this.myFrame.setVisible(true);
    }

    private PropertiesPanel getPropertiesPanel() {
        this.editor = new GeneratorPropertiesEditor(this.currentGenerator);
        this.editor.fillPropertiesForGenerator();
        PropertiesPanel p = this.editor.getPropertiesPanel();
        return p;
    }

    private void updatePropertiesPanel() {
        if (this.editor == null) {
            this.editor = new GeneratorPropertiesEditor(this.currentGenerator);
        } else {
            this.editor.setGenerator(this.currentGenerator);
        }
        this.editor.fillPropertiesForGenerator();
    }

    private boolean generateGeneratorContent() {
        String animalGenerator = trans.translateMessage("animalGenerator");
        File selFile = new File(this.txtFileName.getText());
        if (selFile.exists()) {
            if (!selFile.isFile()) {
                JOptionPane.showMessageDialog(this.myFrame, trans.translateMessage("invalidFilename", selFile.getPath()), animalGenerator, 0);
                return false;
            }
            int ret = JOptionPane.showConfirmDialog(this.myFrame, trans.translateMessage("invalidFilename", selFile.getPath()), animalGenerator, 0);
            if (ret == 1) {
                return false;
            }
        }
        BufferedWriter buf = null;
        try {
            try {
                FileWriter out = new FileWriter(selFile);
                buf = new BufferedWriter(out);
                PropertiesTreeModel aModel = (PropertiesTreeModel)this.editor.getPropertiesPanel().getTree().getModel();
                buf.write(this.currentGenerator.generate(aModel.getPropertiesContainer(), aModel.getPrimitivesContainer()));
                buf.flush();
                buf.close();
                int choice = JOptionPane.showConfirmDialog(this.myFrame, trans.translateMessage("exitNow"), animalGenerator, 0, 3);
                if (choice == 0) {
                    this.myFrame.dispose();
                }
            }
            catch (IOException e1) {
                JOptionPane.showMessageDialog(this.myFrame, trans.translateMessage("errorWriting", selFile.getPath()), animalGenerator, 0);
                try {
                    if (buf != null) {
                        buf.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return false;
            }
        }
        finally {
            try {
                if (buf != null) {
                    buf.close();
                }
            }
            catch (Exception exception) {}
        }
        return true;
    }

    private DefaultMutableTreeNode addCategory(String category, String chainPath, DefaultMutableTreeNode baseNode) {
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(category);
        this.generators.put(chainPath, node);
        if (baseNode != null) {
            baseNode.add(node);
        }
        return node;
    }

    private void addGenerator(Generator generator, String chainPath, DefaultMutableTreeNode parent) {
        GeneratorTreeNode node = new GeneratorTreeNode(generator);
        this.generators.put(chainPath, node);
        if (parent != null) {
            parent.add(node);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath currentPath = e.getPath();
        if (currentPath != null) {
            this.generateEditorPaneContent(currentPath.getPathCount(), currentPath.getLastPathComponent());
        }
    }

    private void addDefaultHTMLStart(StringBuilder sb) {
        sb.append(trans.translateMessage("htmlHead"));
    }

    private void addDefaultHTMLEnd(StringBuilder sb) {
        sb.append("\n</body>\n</html>");
    }

    private void generateEditorPaneContent(int pathLength, Object lastPathComponent) {
        this.confirmButton.setEnabled(false);
        this.currentGenerator = null;
        StringBuilder contentBuffer = new StringBuilder(4096);
        if (pathLength < 5 || pathLength == 6) {
            this.addDefaultHTMLStart(contentBuffer);
        }
        switch (pathLength) {
            case 1: {
                contentBuffer.append(trans.translateMessage("Generators"));
                break;
            }
            case 2: {
                contentBuffer.append(trans.translateMessage("languageChoice", new Object[]{lastPathComponent, trans.translateMessage(lastPathComponent.toString())}));
                break;
            }
            case 3: {
                contentBuffer.append(trans.translateMessage("plChoice", trans.translateMessage(lastPathComponent.toString())));
                break;
            }
            case 4: {
                contentBuffer.append(trans.translateMessage(lastPathComponent.toString()));
                break;
            }
            case 6: {
                Generator generator;
                if (!(lastPathComponent instanceof GeneratorTreeNode)) break;
                GeneratorTreeNode generatorNode = (GeneratorTreeNode)lastPathComponent;
                this.currentGenerator = generator = generatorNode.getGenerator();
                contentBuffer.append(trans.translateMessage("algoTemplate", generator.getName(), generator.getAlgorithmName(), generator.getOutputLanguage(), generator.getContentLocale().toString(), generator.getFileExtension(), generator.getDescription(), generator.getCodeExample()));
                this.confirmButton.setEnabled(true);
            }
        }
        if (pathLength < 5 || pathLength == 6) {
            this.addDefaultHTMLEnd(contentBuffer);
        }
        this.editorPane.setText(contentBuffer.toString());
        this.editorPane.setCaretPosition(0);
    }

    private JSplitPane getMainPanel() {
        JScrollPane treeScrollPane = new JScrollPane(this.myTree);
        treeScrollPane.setPreferredSize(new Dimension(200, 288));
        this.editorPane = new JEditorPane();
        this.editorPane.setEditable(false);
        this.editorPane.setContentType("text/html");
        JScrollPane editorScrollPane = new JScrollPane(this.editorPane);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setLeftComponent(treeScrollPane);
        splitPane.setRightComponent(editorScrollPane);
        return splitPane;
    }

    private JPanel getFileChoicePanel() {
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 3));
        JPanel panelTextField = new JPanel();
        panelTextField.setLayout(new BorderLayout(8, 8));
        JLabel filenameLabel = new JLabel(trans.translateMessage("filenamePrompt"));
        panelTextField.add((Component)filenameLabel, "Before");
        panelTextField.add((Component)this.txtFileName, "Center");
        int txtHeight = this.txtFileName.getPreferredSize().height;
        panelTextField.setPreferredSize(new Dimension(300, txtHeight + 5));
        panelTextField.setMaximumSize(new Dimension(600, txtHeight + 5));
        p.add(panelTextField);
        p.add(Box.createRigidArea(new Dimension(0, 16)));
        JPanel panelButton = new JPanel();
        panelButton.setLayout(new BorderLayout(8, 8));
        JButton but = new JButton(trans.translateMessage("browse"));
        but.setActionCommand("browse");
        but.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                GeneratorDemo.this.browseForFilename();
            }
        });
        panelButton.add((Component)but, "After");
        int butHeight = but.getPreferredSize().height;
        but.setPreferredSize(new Dimension(200, butHeight + 5));
        panelButton.setPreferredSize(new Dimension(300, butHeight + 5));
        panelButton.setMaximumSize(new Dimension(600, butHeight + 5));
        p.add(panelButton);
        return p;
    }

    private void browseForFilename() {
        JFileChooser fc;
        if (this.txtFileName.getText().length() > 0) {
            File start = new File(this.txtFileName.getText());
            fc = new JFileChooser(start.getParent());
        } else {
            fc = new JFileChooser();
        }
        fc.addChoosableFileFilter(new CustomFileFilter(this.currentGenerator.getFileExtension()));
        int result = fc.showSaveDialog(this.myFrame);
        if (result != 0) {
            return;
        }
        File selFile = fc.getSelectedFile();
        try {
            String strFile = selFile.getCanonicalPath();
            if (selFile.getName().indexOf(".") == -1) {
                strFile = strFile.concat("." + this.currentGenerator.getFileExtension());
            }
            this.txtFileName.setText(strFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected Vector<String> readListOfGenerators() {
        Vector<String> vec;
        block30: {
            File f;
            String path;
            ClassLoader cl;
            vec = new Vector<String>();
            URL url = null;
            if (this.generatorDummy == null) {
                try {
                    this.generatorDummy = Class.forName("generatorImplementations.DummyGenerator");
                }
                catch (ClassNotFoundException cfe) {
                    System.err.println("DummyGenerator could not be found!");
                }
            }
            if (this.generatorDummy != null && (cl = this.generatorDummy.getClassLoader()) != null) {
                url = cl.getResource("generatorImplementations");
            }
            if ((path = url.toString()).startsWith("jar:")) {
                if (path.endsWith(".jar")) {
                    path = path.substring(4, path.indexOf(".jar") + 4);
                } else if (path.indexOf("!") > 0) {
                    path = path.substring(4, path.indexOf("!"));
                }
                ZipInputStream jf = null;
                try {
                    try {
                        JarEntry entry;
                        jf = new JarInputStream(new URL(path).openConnection().getInputStream());
                        while ((entry = ((JarInputStream)jf).getNextJarEntry()) != null) {
                            String name = entry.getName();
                            if (!name.startsWith("generatorImplementations") || name.length() < 31) continue;
                            name = name.substring(25, name.length() - 6);
                            vec.add(name);
                        }
                        break block30;
                    }
                    catch (Exception e) {
                        System.err.println(String.valueOf(e.getClass().getName()) + " // " + e.getMessage());
                        Vector<String> vector = vec;
                        try {
                            jf.close();
                        }
                        catch (IOException ioe) {
                            System.err.println(String.valueOf(ioe.getClass().getName()) + " // " + ioe.getMessage());
                        }
                        return vector;
                    }
                }
                finally {
                    try {
                        jf.close();
                    }
                    catch (IOException ioe) {
                        System.err.println(String.valueOf(ioe.getClass().getName()) + " // " + ioe.getMessage());
                    }
                }
            }
            try {
                f = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                return vec;
            }
            if (f == null) {
                return vec;
            }
            String[] files = f.list();
            if (files == null) {
                return vec;
            }
            int i = 0;
            while (i < files.length) {
                if (files[i].endsWith(".class")) {
                    vec.add(files[i].substring(0, files[i].length() - 6));
                }
                ++i;
            }
        }
        try {
            Properties config = null;
            InputStream in = this.getClass().getResourceAsStream("/generators.dat");
            if (in != null) {
                BufferedInputStream bins = new BufferedInputStream(in);
                config = new Properties();
                config.load(bins);
                bins.close();
                in.close();
                Enumeration<?> keys = config.propertyNames();
                while (keys.hasMoreElements()) {
                    String elementKey = (String)config.get(keys.nextElement());
                    if (vec.contains(elementKey)) continue;
                    vec.add(config.getProperty((String)keys.nextElement()));
                }
            }
        }
        catch (IOException ioex) {
            MessageDisplay.errorMsg(AnimalTranslator.translateMessage("genSpecMissing"), 4);
        }
        return vec;
    }
}

