/*
 * Decompiled with CFR 0.152.
 */
package de.ahrgr.animal.kohnert.asugen.petri;

import de.ahrgr.animal.kohnert.asugen.AnimalObject;
import de.ahrgr.animal.kohnert.asugen.AnimalScriptWriter;
import de.ahrgr.animal.kohnert.asugen.Circle;
import de.ahrgr.animal.kohnert.asugen.Color;
import de.ahrgr.animal.kohnert.asugen.Node;
import de.ahrgr.animal.kohnert.asugen.PolyLine;
import de.ahrgr.animal.kohnert.asugen.Rectangle;
import de.ahrgr.animal.kohnert.asugen.Text;
import de.ahrgr.animal.kohnert.asugen.petri.Stelle;
import java.util.ArrayList;

public class Transition
extends AnimalObject {
    protected ArrayList<Link> vorbereich;
    protected ArrayList<Link> nachbereich;
    protected Rectangle rect;
    protected Text text;

    public Transition(AnimalScriptWriter sw, Node aPosition, String aText) {
        super(sw);
        this.position = aPosition;
        this.rect = new Rectangle(sw, aPosition.createOffset(-5, -20), this.position.createOffset(5, 20));
        this.rect.setFillColor(Color.BLUE);
        this.text = new Text(sw, this.rect.createOffset(-10, -10, 0), aText);
        this.vorbereich = new ArrayList();
        this.nachbereich = new ArrayList();
    }

    public void addNachbereich(Stelle s) {
        Link l = new Link();
        l.stelle = s;
        l.line = new PolyLine(this.scriptwriter);
        l.line.addNode(this.rect.createOffset(0, 0, 5));
        l.line.addNode(s.createOffset(0, 0, 3));
        l.line.setArrow(1);
        this.nachbereich.add(l);
        if (this.registered) {
            l.line.register();
        }
    }

    public void addVorbereich(Stelle s) {
        Link l = new Link();
        l.stelle = s;
        l.line = new PolyLine(this.scriptwriter);
        l.line.addNode(s.createOffset(0, 0, 5));
        l.line.addNode(this.rect.createOffset(0, 0, 3));
        l.line.setArrow(1);
        this.vorbereich.add(l);
        if (this.registered) {
            l.line.register();
        }
    }

    public void setColor(Color c) {
        this.rect.setColor(c);
    }

    public void setFillColor(Color c) {
        this.rect.setFillColor(c);
    }

    public void register() {
        if (this.registered) {
            return;
        }
        this.rect.register();
        this.text.register();
        for (Link l : this.vorbereich) {
            l.stelle.register();
            l.line.register();
        }
        for (Link l : this.nachbereich) {
            l.stelle.register();
            l.line.register();
        }
        this.registered = true;
    }

    public void animiereVorbereich() {
        for (Link l : this.vorbereich) {
            if (l.animStelle == null) {
                l.animStelle = new Circle(this.scriptwriter, l.stelle.createOffset(-10, -10, 4), 10);
                l.animStelle.setFillColor(Color.BLACK);
                l.animStelle.register();
            } else {
                l.animStelle.setHidden(false);
            }
            l.animStelle.moveTo(this.rect.createOffset(-10, -10, 4));
        }
    }

    public void animiereNachbereich() {
        for (Link l : this.nachbereich) {
            if (l.animStelle == null) {
                l.animStelle = new Circle(this.scriptwriter, this.rect.createOffset(-10, -10, 4), 10);
                l.animStelle.setFillColor(Color.BLACK);
                l.animStelle.register();
            } else {
                l.animStelle.setHidden(false);
            }
            l.animStelle.moveTo(l.stelle.createOffset(-10, -10, 4));
        }
    }

    public void resetVorbereichAnimation() {
        for (Link l : this.vorbereich) {
            if (l.animStelle == null) continue;
            l.animStelle.setPosition(l.stelle.createOffset(-10, -10, 4));
            l.animStelle.setHidden(true);
        }
    }

    public void resetNachbereichAnimation() {
        for (Link l : this.nachbereich) {
            if (l.animStelle == null) continue;
            l.animStelle.setPosition(this.rect.createOffset(-10, -10, 4));
            l.animStelle.setHidden(true);
        }
    }

    class Link {
        Circle animStelle = null;
        PolyLine line;
        Stelle stelle;

        Link() {
        }
    }
}

