/*
 * Decompiled with CFR 0.152.
 */
package components;

import components.ArrayInputTable;
import components.IntegerTextFieldEx;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StringArrayInputPanel
extends JPanel
implements ActionListener,
FocusListener {
    private static final long serialVersionUID = 3257289145079313976L;
    public IntegerTextFieldEx txtNumberOfElements;
    public ArrayInputTable tblElements;

    public StringArrayInputPanel() {
        String[] values = new String[]{"A", "B", "C", "D"};
        this.init(values);
    }

    public StringArrayInputPanel(String[] values) {
        if (values == null || values.length == 0) {
            String[] elems = new String[]{"A", "B", "C", "D"};
            this.init(elems);
        } else {
            String[] elems = new String[values.length];
            System.arraycopy(values, 0, elems, 0, values.length);
            this.init(elems);
        }
    }

    private void init(String[] elements) {
        this.setLayout(new BoxLayout(this, 3));
        this.txtNumberOfElements = new IntegerTextFieldEx(1, 128);
        this.txtNumberOfElements.setDefaultValue(new Integer(8));
        this.txtNumberOfElements.setText(Integer.toString(elements.length));
        this.txtNumberOfElements.addActionListener(this);
        this.txtNumberOfElements.addFocusListener(this);
        this.txtNumberOfElements.setAlignmentX(0.0f);
        this.tblElements = new ArrayInputTable(elements);
        this.tblElements.setAlignmentX(0.0f);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 2));
        p.add(new JLabel("Number of elements:"));
        p.add(Box.createRigidArea(new Dimension(10, 1)));
        p.add(this.txtNumberOfElements);
        p.setAlignmentX(0.0f);
        this.add(p);
        this.add(Box.createRigidArea(new Dimension(1, 8)));
        this.add(Box.createRigidArea(new Dimension(1, 2)));
        this.add(this.tblElements);
    }

    private void updateTable() {
        this.tblElements.setNumberOfElements(this.txtNumberOfElements.getValue());
    }

    public void actionPerformed(ActionEvent e) {
        if (e == null) {
            return;
        }
        this.updateTable();
    }

    public void focusLost(FocusEvent e) {
        if (e == null) {
            return;
        }
        this.updateTable();
    }

    public void focusGained(FocusEvent e) {
        if (e == null) {
            return;
        }
    }
}

